/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.util;

import com.allanbank.mongodb.MongoDbException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class FutureUtils {
    public static <T> T unwrap(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.fillInStackTrace();
            throw new MongoDbException(interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            throwable.fillInStackTrace();
            if (throwable instanceof MongoDbException) {
                throw (MongoDbException)throwable;
            }
            throw new MongoDbException(throwable);
        }
    }

    private FutureUtils() {
    }
}

