/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.error;

import com.allanbank.mongodb.builder.BatchedWrite;
import com.allanbank.mongodb.builder.write.WriteOperation;
import com.allanbank.mongodb.error.ReplyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class BatchedWriteException
extends ReplyException {
    private static final long serialVersionUID = -7797670480003384909L;
    private final Map<WriteOperation, Throwable> myErrors;
    private final long myN;
    private final List<WriteOperation> mySkipped;
    private final BatchedWrite myWrite;

    private static String createErrorMessage(Map<WriteOperation, Throwable> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map.size() == 1) {
            stringBuilder.append("Error sending a batched write: ");
            stringBuilder.append(map.values().iterator().next().getMessage());
        } else {
            stringBuilder.append(map.size());
            stringBuilder.append(" errors sending a batched write. Unique error messages:\n\t");
            HashSet<String> hashSet = new HashSet<String>();
            for (Throwable throwable : map.values()) {
                String string = throwable.getMessage();
                if (!hashSet.add(string)) continue;
                stringBuilder.append(string);
                stringBuilder.append("\n\t");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        return stringBuilder.toString();
    }

    public BatchedWriteException(BatchedWrite batchedWrite, long l, List<WriteOperation> list, Map<WriteOperation, Throwable> map) {
        super(null, BatchedWriteException.createErrorMessage(map));
        this.myWrite = batchedWrite;
        this.myN = l;
        this.mySkipped = Collections.unmodifiableList(new ArrayList<WriteOperation>(list));
        this.myErrors = Collections.unmodifiableMap(new IdentityHashMap<WriteOperation, Throwable>(map));
    }

    public Map<WriteOperation, Throwable> getErrors() {
        return this.myErrors;
    }

    public long getN() {
        return this.myN;
    }

    public List<WriteOperation> getSkipped() {
        return this.mySkipped;
    }

    public BatchedWrite getWrite() {
        return this.myWrite;
    }
}

