/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.state;

import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.state.AbstractReconnectStrategy;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.io.IOException;
import java.util.List;

public class SimpleReconnectStrategy
extends AbstractReconnectStrategy {
    protected static final Log LOG = LogFactory.getLog(SimpleReconnectStrategy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection reconnect(Connection connection) {
        boolean bl = Thread.interrupted();
        try {
            Server server = this.myState.get(connection.getServerName());
            Connection connection2 = this.tryConnect(server);
            if (connection2 != null) {
                Connection connection3 = connection2;
                return connection3;
            }
            List<Server> list = this.getSelector().pickServers();
            for (Server server2 : list) {
                connection2 = this.tryConnect(server2);
                if (connection2 == null) continue;
                Connection connection4 = connection2;
                return connection4;
            }
            LOG.info("Reconnect attempt failed for all {} servers: {}", list.size(), list);
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection tryConnect(Server server) {
        Connection connection;
        block4: {
            Connection connection2;
            connection = null;
            try {
                connection = this.getConnectionFactory().connect(server, this.getConfig());
                if (!this.isConnected(server, connection)) break block4;
                LOG.info("Reconnected to {}", server);
                Connection connection3 = connection;
                connection = null;
                connection2 = connection3;
            }
            catch (IOException iOException) {
                try {
                    LOG.debug("Reconnect to {} failed: {}", server, iOException.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.close(connection);
                    throw throwable;
                }
                IOUtils.close(connection);
            }
            IOUtils.close(connection);
            return connection2;
        }
        IOUtils.close(connection);
        return null;
    }
}

