/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.state;

import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.TimestampElement;
import com.allanbank.mongodb.util.ServerNameUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class Server {
    public static final String CANONICAL_NAME_PROP = "canonicalName";
    public static final double DECAY_ALPHA;
    public static final double DECAY_SAMPLES = 1000.0;
    public static final int DEFAULT_PORT = 27017;
    public static final Class<DocumentElement> DOCUMENT_TYPE;
    public static final int MAX_BATCHED_WRITE_OPERATIONS_DEFAULT = 1000;
    public static final String MAX_BATCHED_WRITE_OPERATIONS_PROP = "maxWriteBatchSize";
    public static final String MAX_BSON_OBJECT_SIZE_PROP = "maxBsonObjectSize";
    public static final Class<NumericElement> NUMERIC_TYPE;
    public static final int PRIMARY_STATE = 1;
    public static final int SECONDARY_STATE = 2;
    public static final String STATE_PROP = "state";
    public static final Class<StringElement> STRING_TYPE;
    public static final String TAGS_PROP = "tags";
    public static final Class<TimestampElement> TIMESTAMP_TYPE;
    public static final String VERSION_PROP = "version";
    private static final double NANOS_PER_MILLI;
    private volatile double myAverageLatency;
    private final InetSocketAddress myCanonicalAddress;
    private final String myCanonicalHostName;
    private volatile String myCanonicalName;
    private final PropertyChangeSupport myEventSupport;
    private long myLastVersionUpdate = 0L;
    private volatile int myMaxBatchedWriteOperations = 1000;
    private volatile int myMaxBsonObjectSize = 0x1000000;
    private final AtomicLong myMessagesSent;
    private final AtomicLong myRepliesReceived;
    private volatile double mySecondsBehind;
    private volatile State myState;
    private volatile Document myTags;
    private final AtomicLong myTotalLatency;
    private Version myVersion;
    private volatile InetSocketAddress myWorkingAddress;

    Server(InetSocketAddress inetSocketAddress) {
        this.myCanonicalAddress = inetSocketAddress;
        this.myCanonicalHostName = inetSocketAddress.getHostName();
        this.myCanonicalName = ServerNameUtils.normalize(inetSocketAddress);
        this.myWorkingAddress = this.myCanonicalAddress;
        this.myEventSupport = new PropertyChangeSupport(this);
        this.myMessagesSent = new AtomicLong(0L);
        this.myRepliesReceived = new AtomicLong(0L);
        this.myTotalLatency = new AtomicLong(0L);
        this.myState = State.UNKNOWN;
        this.myAverageLatency = Double.MAX_VALUE;
        this.mySecondsBehind = Double.MAX_VALUE;
        this.myTags = null;
        this.myVersion = Version.UNKNOWN;
    }

    public void addListener(PropertyChangeListener propertyChangeListener) {
        this.myEventSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void connectFailed() {
        State state = this.myState;
        this.myWorkingAddress = null;
        this.myState = State.UNAVAILABLE;
        this.myEventSupport.firePropertyChange(STATE_PROP, (Object)state, (Object)this.myState);
    }

    public void connectionClosed() {
    }

    public void connectionOpened(InetSocketAddress inetSocketAddress) {
        this.myWorkingAddress = inetSocketAddress;
    }

    public void connectionTerminated() {
        State state = this.myState;
        this.myWorkingAddress = null;
        this.myState = State.UNAVAILABLE;
        this.myEventSupport.firePropertyChange(STATE_PROP, (Object)state, (Object)this.myState);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public Collection<InetSocketAddress> getAddresses() {
        if (this.myWorkingAddress == null) {
            this.myWorkingAddress = InetSocketAddress.createUnresolved(this.myCanonicalHostName, this.myCanonicalAddress.getPort());
        }
        if (this.myCanonicalAddress == this.myWorkingAddress) {
            return Collections.singleton(this.myCanonicalAddress);
        }
        return Arrays.asList(this.myWorkingAddress, this.myCanonicalAddress);
    }

    public double getAverageLatency() {
        return this.myAverageLatency;
    }

    public String getCanonicalName() {
        return this.myCanonicalName;
    }

    public int getMaxBatchedWriteOperations() {
        return this.myMaxBatchedWriteOperations;
    }

    public int getMaxBsonObjectSize() {
        return this.myMaxBsonObjectSize;
    }

    public long getMessagesSent() {
        return this.myMessagesSent.get();
    }

    public long getRepliesReceived() {
        return this.myRepliesReceived.get();
    }

    public double getSecondsBehind() {
        return this.mySecondsBehind;
    }

    public State getState() {
        return this.myState;
    }

    public Document getTags() {
        return this.myTags;
    }

    public long getTotalLatencyNanoSeconds() {
        return this.myTotalLatency.get();
    }

    public Version getVersion() {
        return this.myVersion;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public void incrementMessagesSent() {
        this.myMessagesSent.incrementAndGet();
    }

    public void incrementRepliesReceived() {
        this.myRepliesReceived.incrementAndGet();
    }

    public boolean isWritable() {
        return this.myState == State.WRITABLE;
    }

    public boolean needBuildInfo() {
        long l = System.currentTimeMillis();
        long l2 = l - TimeUnit.MINUTES.toMillis(10L);
        return Version.UNKNOWN.equals(this.myVersion) || this.myLastVersionUpdate < l2;
    }

    public void removeListener(PropertyChangeListener propertyChangeListener) {
        this.myEventSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void requestFailed() {
        this.mySecondsBehind = 2.147483647E9;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getCanonicalName());
        stringBuilder.append("(");
        stringBuilder.append((Object)this.myState);
        stringBuilder.append(",");
        if (this.myTags != null) {
            stringBuilder.append("T,");
        }
        stringBuilder.append(this.getAverageLatency());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void update(Document document) {
        this.updateState(document);
        this.updateSecondsBehind(document);
        this.updateTags(document);
        this.updateName(document);
        this.updateVersion(document);
        this.updateMaxBsonObjectSize(document);
        this.updateMaxWriteOperations(document);
    }

    public void updateAverageLatency(long l) {
        this.myTotalLatency.addAndGet(l);
        double d = (double)l / NANOS_PER_MILLI;
        double d2 = this.myAverageLatency;
        if (Double.MAX_VALUE == d2) {
            this.myAverageLatency = d;
            if (this.mySecondsBehind == Double.MAX_VALUE) {
                this.mySecondsBehind = 0.0;
            }
        } else {
            this.myAverageLatency = DECAY_ALPHA * d + (1.0 - DECAY_ALPHA) * d2;
        }
    }

    private void updateMaxBsonObjectSize(Document document) {
        int n = this.myMaxBsonObjectSize;
        NumericElement numericElement = document.findFirst(NUMERIC_TYPE, MAX_BSON_OBJECT_SIZE_PROP);
        if (numericElement != null) {
            this.myMaxBsonObjectSize = numericElement.getIntValue();
        }
        this.myEventSupport.firePropertyChange(MAX_BSON_OBJECT_SIZE_PROP, n, this.myMaxBsonObjectSize);
    }

    private void updateMaxWriteOperations(Document document) {
        int n = this.myMaxBatchedWriteOperations;
        NumericElement numericElement = document.findFirst(NUMERIC_TYPE, MAX_BATCHED_WRITE_OPERATIONS_PROP);
        if (numericElement != null) {
            this.myMaxBatchedWriteOperations = numericElement.getIntValue();
        }
        this.myEventSupport.firePropertyChange(MAX_BATCHED_WRITE_OPERATIONS_PROP, n, this.myMaxBatchedWriteOperations);
    }

    private void updateName(Document document) {
        String string;
        String string2 = this.myCanonicalName;
        Element element = document.findFirst("me");
        if (element != null && (string = element.getValueAsString()) != null && !this.myCanonicalName.equals(string)) {
            this.myCanonicalName = string;
        }
        this.myEventSupport.firePropertyChange(CANONICAL_NAME_PROP, string2, this.myCanonicalName);
    }

    private void updateSecondsBehind(Document document) {
        State state = this.myState;
        NumericElement numericElement = document.get(NUMERIC_TYPE, "myState");
        if (numericElement != null) {
            int n = numericElement.getIntValue();
            if (n == 1) {
                this.myState = State.WRITABLE;
                this.mySecondsBehind = 0.0;
            } else if (n == 2) {
                this.myState = State.READ_ONLY;
                TimestampElement timestampElement = null;
                StringElement stringElement = new StringElement("name", this.myCanonicalName);
                for (DocumentElement object : document.find(DOCUMENT_TYPE, "members", ".*")) {
                    if (!stringElement.equals(object.get("name")) || object.get(TIMESTAMP_TYPE, "optimeDate") == null) continue;
                    timestampElement = object.get(TIMESTAMP_TYPE, "optimeDate");
                }
                if (timestampElement != null) {
                    Object object = timestampElement;
                    for (TimestampElement timestampElement2 : document.find(TIMESTAMP_TYPE, "members", ".*", "optimeDate")) {
                        if (((TimestampElement)object).getTime() >= timestampElement2.getTime()) continue;
                        object = timestampElement2;
                    }
                    double d = ((TimestampElement)object).getTime() - timestampElement.getTime();
                    this.mySecondsBehind = d / (double)TimeUnit.SECONDS.toMillis(1L);
                }
            } else {
                this.mySecondsBehind = Double.MAX_VALUE;
                this.myState = State.UNAVAILABLE;
            }
        }
        this.myEventSupport.firePropertyChange(STATE_PROP, (Object)state, (Object)this.myState);
    }

    private void updateState(Document document) {
        State state = this.myState;
        BooleanElement booleanElement = document.findFirst(BooleanElement.class, "ismaster");
        if (booleanElement != null) {
            if (booleanElement.getValue()) {
                this.myState = State.WRITABLE;
                this.mySecondsBehind = 0.0;
            } else {
                booleanElement = document.findFirst(BooleanElement.class, "secondary");
                if (booleanElement != null && booleanElement.getValue()) {
                    this.myState = State.READ_ONLY;
                    if (this.mySecondsBehind == Double.MAX_VALUE || this.mySecondsBehind == 2.147483647E9) {
                        this.mySecondsBehind = 0.0;
                    }
                } else {
                    this.myState = State.UNAVAILABLE;
                }
            }
        }
        this.myEventSupport.firePropertyChange(STATE_PROP, (Object)state, (Object)this.myState);
    }

    private void updateTags(Document document) {
        Document document2 = this.myTags;
        Document document3 = document.findFirst(DOCUMENT_TYPE, TAGS_PROP);
        if (document3 != null) {
            if ((document3 = BuilderFactory.start((DocumentAssignable)document3.asDocument()).build()).getElements().isEmpty()) {
                this.myTags = null;
            } else if (!document3.equals(this.myTags)) {
                this.myTags = document3;
            }
        }
        this.myEventSupport.firePropertyChange(TAGS_PROP, document2, this.myTags);
    }

    private void updateVersion(Document document) {
        Version version = this.myVersion;
        List<NumericElement> list = document.find(NUMERIC_TYPE, "versionArray", ".*");
        if (!list.isEmpty()) {
            this.myVersion = Version.parse(list);
            this.myLastVersionUpdate = System.currentTimeMillis();
        } else {
            StringElement stringElement = document.findFirst(STRING_TYPE, VERSION_PROP);
            if (stringElement != null) {
                this.myVersion = Version.parse(stringElement.getValue());
                this.myLastVersionUpdate = System.currentTimeMillis();
            } else {
                NumericElement numericElement = document.findFirst(NUMERIC_TYPE, "maxWireVersion");
                if (numericElement != null) {
                    Version version2 = Version.forWireVersion(numericElement.getIntValue());
                    if (version.equals(Version.UNKNOWN) || version.compareTo(version2) < 0) {
                        this.myVersion = version2;
                    }
                }
            }
        }
        this.myEventSupport.firePropertyChange(VERSION_PROP, version, this.myVersion);
    }

    static {
        DOCUMENT_TYPE = DocumentElement.class;
        NUMERIC_TYPE = NumericElement.class;
        STRING_TYPE = StringElement.class;
        TIMESTAMP_TYPE = TimestampElement.class;
        NANOS_PER_MILLI = TimeUnit.MILLISECONDS.toNanos(1L);
        DECAY_ALPHA = 0.001998001998001998;
    }

    public static enum State {
        READ_ONLY,
        UNAVAILABLE,
        UNKNOWN,
        WRITABLE;

    }
}

