/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.state;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.client.ClusterType;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.client.message.IsMaster;
import com.allanbank.mongodb.client.message.ReplicaSetStatus;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerUpdateCallback;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClusterPinger
implements Runnable,
Closeable {
    public static final int DEFAULT_PING_INTERVAL_SECONDS = 600;
    protected static final Log LOG = LogFactory.getLog(ClusterPinger.class);
    private static final Pinger PINGER = new Pinger();
    private final List<Cluster> myClusters;
    private final MongoClientConfiguration myConfig;
    private final ProxiedConnectionFactory myConnectionFactory;
    private volatile TimeUnit myIntervalUnits;
    private volatile int myPingSweepInterval;
    private final Thread myPingThread;
    private volatile boolean myRunning;

    public static boolean ping(Server server, Connection connection) {
        return PINGER.ping(server, connection);
    }

    public ClusterPinger(Cluster cluster, ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        this.myConnectionFactory = proxiedConnectionFactory;
        this.myConfig = mongoClientConfiguration;
        this.myRunning = true;
        this.myClusters = new CopyOnWriteArrayList<Cluster>();
        this.myClusters.add(cluster);
        this.myIntervalUnits = TimeUnit.SECONDS;
        this.myPingSweepInterval = 600;
        this.myPingThread = this.myConfig.getThreadFactory().newThread(this);
        this.myPingThread.setDaemon(true);
        this.myPingThread.setName("MongoDB Pinger");
        this.myPingThread.setPriority(1);
    }

    public void addCluster(Cluster cluster) {
        this.myClusters.add(cluster);
    }

    @Override
    public void close() {
        this.myRunning = false;
        this.myPingThread.interrupt();
    }

    public TimeUnit getIntervalUnits() {
        return this.myIntervalUnits;
    }

    public int getPingSweepInterval() {
        return this.myPingSweepInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialSweep(Cluster cluster) {
        List<Server> list = cluster.getServers();
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        ArrayList<Connection> arrayList2 = new ArrayList<Connection>(list.size());
        try {
            Object object;
            for (Server object2 : list) {
                String string = object2.getCanonicalName();
                Connection connection = null;
                try {
                    connection = this.myConnectionFactory.connect(object2, this.myConfig);
                    object = PINGER.pingAsync(cluster.getType(), object2, connection);
                    arrayList.add(object);
                }
                catch (IOException iOException) {
                    LOG.info("Could not ping '{}': {}", string, iOException.getMessage());
                }
                finally {
                    if (connection == null) continue;
                    arrayList2.add(connection);
                    connection.shutdown(false);
                }
            }
            long l = System.currentTimeMillis();
            long l2 = l + (long)Math.max(5000, this.myConfig.getConnectTimeout());
            while (l < l2 && !arrayList.isEmpty()) {
                object = arrayList.iterator();
                while (object.hasNext() && l < l2) {
                    Future future = (Future)object.next();
                    try {
                        if (future != null) {
                            future.get(l2 - l, TimeUnit.MILLISECONDS);
                        }
                        object.remove();
                    }
                    catch (ExecutionException interruptedException) {
                        object.remove();
                    }
                    catch (TimeoutException timeoutException) {
                        future = null;
                    }
                    catch (InterruptedException interruptedException) {
                        future = null;
                    }
                    l = System.currentTimeMillis();
                }
            }
        }
        finally {
            for (Connection connection : arrayList2) {
                IOUtils.close(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.myRunning) {
            try {
                Map<Server, ClusterType> map = this.extractAllServers();
                long l = this.getIntervalUnits().toMillis(this.getPingSweepInterval());
                long l2 = map.isEmpty() ? l : l / (long)map.size();
                Thread.sleep(TimeUnit.MILLISECONDS.toMillis(l2));
                this.startSweep();
                for (Map.Entry<Server, ClusterType> entry : map.entrySet()) {
                    Server server = entry.getKey();
                    String string = server.getCanonicalName();
                    Connection connection = null;
                    try {
                        this.myPingThread.setName("MongoDB Pinger - " + string);
                        connection = this.myConnectionFactory.connect(server, this.myConfig);
                        PINGER.pingAsync(entry.getValue(), server, connection);
                        Thread.sleep(TimeUnit.MILLISECONDS.toMillis(l2));
                    }
                    catch (IOException iOException) {
                        LOG.info("Could not ping '{}': {}", string, iOException.getMessage());
                    }
                    finally {
                        this.myPingThread.setName("MongoDB Pinger - Idle");
                        if (connection == null) continue;
                        connection.shutdown(true);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LOG.debug("Pinger interrupted.");
            }
        }
    }

    public void setIntervalUnits(TimeUnit timeUnit) {
        this.myIntervalUnits = timeUnit;
    }

    public void setPingSweepInterval(int n) {
        this.myPingSweepInterval = n;
    }

    public void start() {
        this.myPingThread.start();
    }

    public void stop() {
        this.close();
    }

    public void wakeUp() {
        this.myPingThread.interrupt();
    }

    protected void startSweep() {
    }

    private Map<Server, ClusterType> extractAllServers() {
        HashMap<Server, ClusterType> hashMap = new HashMap<Server, ClusterType>();
        for (Cluster cluster : this.myClusters) {
            for (Server server : cluster.getServers()) {
                hashMap.put(server, cluster.getType());
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    protected static final class Pinger {
        protected Pinger() {
        }

        public boolean ping(Server server, Connection connection) {
            try {
                Future<Reply> future = this.pingAsync(ClusterType.STAND_ALONE, server, connection);
                if (future != null) {
                    future.get(1L, TimeUnit.MINUTES);
                    return true;
                }
            }
            catch (ExecutionException executionException) {
                LOG.info(executionException, "Could not ping '{}': {}", server.getCanonicalName(), executionException.getMessage());
            }
            catch (TimeoutException timeoutException) {
                LOG.info(timeoutException, "'{}' might be a zombie - not receiving a response to ping: {}", server.getCanonicalName(), timeoutException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                LOG.info(interruptedException, "Interrupted pinging '{}': {}", server.getCanonicalName(), interruptedException.getMessage());
            }
            return false;
        }

        public Future<Reply> pingAsync(ClusterType clusterType, Server server, Connection connection) {
            try {
                ServerUpdateCallback serverUpdateCallback = new ServerUpdateCallback(server);
                connection.send(new IsMaster(), serverUpdateCallback);
                if (clusterType == ClusterType.REPLICA_SET) {
                    connection.send(new ReplicaSetStatus(), new ServerUpdateCallback(server));
                }
                return serverUpdateCallback;
            }
            catch (MongoDbException mongoDbException) {
                LOG.info("Could not ping '{}': {}", server, mongoDbException.getMessage());
                return null;
            }
        }
    }
}

