/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.state;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.client.ClusterStats;
import com.allanbank.mongodb.client.ClusterType;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.VersionRange;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerLatencyComparator;
import com.allanbank.mongodb.util.ServerNameUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class Cluster
implements ClusterStats {
    public static final String SERVER_PROP = "server";
    public static final String WRITABLE_PROP = "writable";
    protected final MongoClientConfiguration myConfig;
    protected final ConcurrentMap<String, Server> myServers;
    protected VersionRange myServerVersionRange;
    protected int mySmallestMaxBatchedWriteOperations;
    protected long mySmallestMaxBsonObjectSize;
    final PropertyChangeSupport myChangeSupport;
    final ServerListener myListener;
    final CopyOnWriteArrayList<Server> myNonWritableServers;
    final CopyOnWriteArrayList<Server> myWritableServers;
    private final ClusterType myType;

    public Cluster(MongoClientConfiguration mongoClientConfiguration, ClusterType clusterType) {
        this.myConfig = mongoClientConfiguration;
        this.myType = clusterType;
        this.myChangeSupport = new PropertyChangeSupport(this);
        this.myServers = new ConcurrentHashMap<String, Server>();
        this.myWritableServers = new CopyOnWriteArrayList();
        this.myNonWritableServers = new CopyOnWriteArrayList();
        this.myListener = new ServerListener();
        this.myServerVersionRange = VersionRange.range(Version.parse("0"), Version.parse("0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server add(InetSocketAddress inetSocketAddress) {
        String string = ServerNameUtils.normalize(inetSocketAddress);
        Server server = (Server)this.myServers.get(string);
        if (server == null) {
            server = new Server(inetSocketAddress);
            Cluster cluster = this;
            synchronized (cluster) {
                Server server2 = this.myServers.putIfAbsent(string, server);
                if (server2 != null) {
                    server = server2;
                } else {
                    this.myNonWritableServers.add(server);
                    this.myChangeSupport.firePropertyChange(SERVER_PROP, null, server);
                    server.addListener(this.myListener);
                }
            }
        }
        return server;
    }

    public Server add(String string) {
        Server server = (Server)this.myServers.get(string);
        if (server == null) {
            server = this.add(ServerNameUtils.parse(string));
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PropertyChangeListener propertyChangeListener) {
        Cluster cluster = this;
        synchronized (cluster) {
            this.myChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void clear() {
        for (Server server : this.myServers.values()) {
            this.remove(server);
        }
    }

    public List<Server> findCandidateServers(ReadPreference readPreference) {
        List<Server> list = Collections.emptyList();
        switch (readPreference.getMode()) {
            case NEAREST: {
                list = this.findNearestCandidates(readPreference);
                break;
            }
            case PRIMARY_ONLY: {
                list = this.findWritableCandidates(readPreference);
                break;
            }
            case PRIMARY_PREFERRED: {
                list = this.merge(this.findWritableCandidates(readPreference), this.findNonWritableCandidates(readPreference));
                break;
            }
            case SECONDARY_ONLY: {
                list = this.findNonWritableCandidates(readPreference);
                break;
            }
            case SECONDARY_PREFERRED: {
                list = this.merge(this.findNonWritableCandidates(readPreference), this.findWritableCandidates(readPreference));
                break;
            }
            case SERVER: {
                list = this.findCandidateServer(readPreference);
            }
        }
        return list;
    }

    public List<Server> findServers(Message message, Message message2) {
        List<Server> list = Collections.emptyList();
        if (message != null) {
            List<Server> list2 = this.findCandidateServers(message.getReadPreference());
            list = list2;
            if (message2 != null) {
                list = new ArrayList<Server>(list2);
                list2 = this.findCandidateServers(message2.getReadPreference());
                list.retainAll(list2);
            }
        }
        return list;
    }

    public Server get(String string) {
        return this.add(string);
    }

    public List<Server> getNonWritableServers() {
        return new ArrayList<Server>(this.myNonWritableServers);
    }

    public List<Server> getServers() {
        return new ArrayList<Server>(this.myServers.values());
    }

    @Override
    public VersionRange getServerVersionRange() {
        return this.myServerVersionRange;
    }

    @Override
    public int getSmallestMaxBatchedWriteOperations() {
        return this.mySmallestMaxBatchedWriteOperations;
    }

    @Override
    public long getSmallestMaxBsonObjectSize() {
        return this.mySmallestMaxBsonObjectSize;
    }

    public ClusterType getType() {
        return this.myType;
    }

    public List<Server> getWritableServers() {
        return new ArrayList<Server>(this.myWritableServers);
    }

    public void remove(Server server) {
        Server server2 = (Server)this.myServers.remove(server.getCanonicalName());
        if (server2 != null) {
            server2.removeListener(this.myListener);
            this.myNonWritableServers.remove(server2);
            this.myWritableServers.remove(server2);
            this.updateVersions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PropertyChangeListener propertyChangeListener) {
        Cluster cluster = this;
        synchronized (cluster) {
            this.myChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected final double[] cdf(List<Server> list) {
        Collections.sort(list, ServerLatencyComparator.COMPARATOR);
        double[] dArray = new double[list.size()];
        double d = 0.0;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            Server server = list.get(i);
            double d3 = server.getAverageLatency();
            if (d2 == Double.NEGATIVE_INFINITY) {
                d2 = d3;
                d3 = 1.0;
            } else {
                d3 /= d2;
            }
            dArray[i] = d3 = 1.0 / d3;
            d += d3;
        }
        double d4 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (d4 += dArray[i]) / d;
        }
        return dArray;
    }

    protected List<Server> findCandidateServer(ReadPreference readPreference) {
        Server server = (Server)this.myServers.get(readPreference.getServer());
        if (server != null && readPreference.matches(server.getTags())) {
            return Collections.singletonList(server);
        }
        return Collections.emptyList();
    }

    protected List<Server> findNearestCandidates(ReadPreference readPreference) {
        ArrayList<Server> arrayList = new ArrayList<Server>(this.myServers.size());
        for (Server server : this.myServers.values()) {
            if (!readPreference.matches(server.getTags())) continue;
            arrayList.add(server);
        }
        this.sort(arrayList);
        return arrayList;
    }

    protected List<Server> findNonWritableCandidates(ReadPreference readPreference) {
        ArrayList<Server> arrayList = new ArrayList<Server>(this.myNonWritableServers.size());
        for (Server server : this.myNonWritableServers) {
            if (!readPreference.matches(server.getTags()) || !this.isRecentEnough(server.getSecondsBehind())) continue;
            arrayList.add(server);
        }
        this.sort(arrayList);
        return arrayList;
    }

    protected List<Server> findWritableCandidates(ReadPreference readPreference) {
        ArrayList<Server> arrayList = new ArrayList<Server>(this.myWritableServers.size());
        for (Server server : this.myWritableServers) {
            if (!readPreference.matches(server.getTags())) continue;
            arrayList.add(server);
        }
        this.sort(arrayList);
        return arrayList;
    }

    protected final void sort(List<Server> list) {
        double d;
        if (list.isEmpty() || list.size() == 1) {
            return;
        }
        double[] dArray = this.cdf(list);
        int n = Arrays.binarySearch(dArray, d = Math.random());
        if (n < 0) {
            n = Math.abs(n + 1);
        }
        n = Math.min(dArray.length - 1, n);
        Collections.swap(list, 0, n);
    }

    protected void updateVersions() {
        Version version = null;
        Version version2 = null;
        long l = Long.MAX_VALUE;
        int n = Integer.MAX_VALUE;
        for (Server server : this.myServers.values()) {
            version = Version.earlier(version, server.getVersion());
            version2 = Version.later(version2, server.getVersion());
            l = Math.min(l, (long)server.getMaxBsonObjectSize());
            n = Math.min(n, server.getMaxBatchedWriteOperations());
        }
        this.myServerVersionRange = VersionRange.range(version, version2);
        this.mySmallestMaxBsonObjectSize = l;
        this.mySmallestMaxBatchedWriteOperations = n;
    }

    private boolean isRecentEnough(double d) {
        return d * 1000.0 < (double)this.myConfig.getMaxSecondaryLag();
    }

    private final List<Server> merge(List<Server> list, List<Server> list2) {
        List<Server> list3;
        if (list.isEmpty()) {
            list3 = list2;
        } else if (list2.isEmpty()) {
            list3 = list;
        } else {
            list3 = new ArrayList<Server>(list.size() + list2.size());
            list3.addAll(list);
            list3.addAll(list2);
        }
        return list3;
    }

    protected final class ServerListener
    implements PropertyChangeListener {
        protected ServerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Version version;
            String string = propertyChangeEvent.getPropertyName();
            Server server = (Server)propertyChangeEvent.getSource();
            if ("state".equals(string)) {
                boolean bl;
                boolean bl2 = bl = !Cluster.this.myWritableServers.isEmpty();
                if (Server.State.WRITABLE == propertyChangeEvent.getNewValue()) {
                    Cluster.this.myWritableServers.addIfAbsent(server);
                    Cluster.this.myNonWritableServers.remove(server);
                } else if (Server.State.READ_ONLY == propertyChangeEvent.getNewValue()) {
                    Cluster.this.myWritableServers.remove(server);
                    Cluster.this.myNonWritableServers.addIfAbsent(server);
                } else {
                    Cluster.this.myWritableServers.remove(server);
                    Cluster.this.myNonWritableServers.remove(server);
                }
                Cluster.this.myChangeSupport.firePropertyChange(Cluster.WRITABLE_PROP, bl, !Cluster.this.myWritableServers.isEmpty());
            } else if ("canonicalName".equals(string)) {
                Cluster.this.myServers.remove(propertyChangeEvent.getOldValue(), server);
                Server server2 = Cluster.this.myServers.putIfAbsent(server.getCanonicalName(), server);
                if (server2 != null) {
                    Cluster.this.myNonWritableServers.remove(server);
                    Cluster.this.myWritableServers.remove(server);
                    server.removeListener(Cluster.this.myListener);
                    Cluster.this.myChangeSupport.firePropertyChange(Cluster.SERVER_PROP, server, null);
                }
            } else if ("version".equals(string) && (Version.UNKNOWN.equals(version = (Version)propertyChangeEvent.getOldValue()) || Cluster.this.myServerVersionRange.getUpperBounds().compareTo(version) <= 0 || Cluster.this.myServerVersionRange.getLowerBounds().compareTo(version) >= 0)) {
                Cluster.this.updateVersions();
            }
        }
    }
}

