/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.state;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.ReconnectStrategy;
import com.allanbank.mongodb.client.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.client.state.ClusterPinger;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerSelector;

public abstract class AbstractReconnectStrategy
implements ReconnectStrategy {
    protected MongoClientConfiguration myConfig = null;
    protected ProxiedConnectionFactory myConnectionFactory = null;
    protected ServerSelector mySelector = null;
    protected Cluster myState = null;

    public MongoClientConfiguration getConfig() {
        return this.myConfig;
    }

    public ProxiedConnectionFactory getConnectionFactory() {
        return this.myConnectionFactory;
    }

    public ServerSelector getSelector() {
        return this.mySelector;
    }

    public Cluster getState() {
        return this.myState;
    }

    @Override
    public void setConfig(MongoClientConfiguration mongoClientConfiguration) {
        this.myConfig = mongoClientConfiguration;
    }

    @Override
    public void setConnectionFactory(ProxiedConnectionFactory proxiedConnectionFactory) {
        this.myConnectionFactory = proxiedConnectionFactory;
    }

    @Override
    public void setSelector(ServerSelector serverSelector) {
        this.mySelector = serverSelector;
    }

    @Override
    public void setState(Cluster cluster) {
        this.myState = cluster;
    }

    protected boolean isConnected(Server server, Connection connection) {
        return ClusterPinger.ping(server, connection);
    }
}

