/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.BufferingBsonOutputStream;
import com.allanbank.mongodb.client.Operation;
import com.allanbank.mongodb.client.message.AbstractMessage;
import com.allanbank.mongodb.client.message.Header;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Reply
extends AbstractMessage {
    public static final int AWAIT_CAPABLE_BIT = 8;
    public static final int CURSOR_NOT_FOUND_BIT = 1;
    public static final int QUERY_FAILURE_BIT = 2;
    public static final int SHARD_CONFIG_STALE_BIT = 4;
    private final boolean myAwaitCapable;
    private final long myCursorId;
    private final boolean myCursorNotFound;
    private final int myCursorOffset;
    private final boolean myQueryFailed;
    private final int myResponseToId;
    private final List<Document> myResults;
    private final boolean myShardConfigStale;

    public Reply(Header header, BsonInputStream bsonInputStream) throws IOException {
        this.init(".");
        this.myResponseToId = header.getResponseId();
        int n = bsonInputStream.readInt();
        this.myCursorId = bsonInputStream.readLong();
        this.myCursorOffset = bsonInputStream.readInt();
        int n2 = bsonInputStream.readInt();
        this.myResults = new ArrayList<Document>(n2);
        for (int i = 0; i < n2; ++i) {
            this.myResults.add(bsonInputStream.readDocument());
        }
        this.myAwaitCapable = (n & 8) == 8;
        this.myCursorNotFound = (n & 1) == 1;
        this.myQueryFailed = (n & 2) == 2;
        this.myShardConfigStale = (n & 4) == 4;
    }

    public Reply(int n, long l, int n2, List<Document> list, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super("", "", ReadPreference.PRIMARY);
        this.myResponseToId = n;
        this.myCursorId = l;
        this.myCursorOffset = n2;
        this.myResults = new ArrayList<Document>(list);
        this.myAwaitCapable = bl;
        this.myCursorNotFound = bl2;
        this.myQueryFailed = bl3;
        this.myShardConfigStale = bl4;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Reply reply = (Reply)object;
            bl = this.myAwaitCapable == reply.myAwaitCapable && this.myCursorNotFound == reply.myCursorNotFound && this.myQueryFailed == reply.myQueryFailed && this.myShardConfigStale == reply.myShardConfigStale && this.myResponseToId == reply.myResponseToId && this.myCursorOffset == reply.myCursorOffset && this.myCursorId == reply.myCursorId && this.myResults.equals(reply.myResults);
        }
        return bl;
    }

    public long getCursorId() {
        return this.myCursorId;
    }

    public int getCursorOffset() {
        return this.myCursorOffset;
    }

    @Override
    public String getOperationName() {
        return Operation.REPLY.name();
    }

    public int getResponseToId() {
        return this.myResponseToId;
    }

    public List<Document> getResults() {
        return this.myResults;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myAwaitCapable ? 1 : 3);
        n = 31 * n + (this.myCursorNotFound ? 1 : 3);
        n = 31 * n + (this.myQueryFailed ? 1 : 3);
        n = 31 * n + (this.myShardConfigStale ? 1 : 3);
        n = 31 * n + this.myResponseToId;
        n = 31 * n + this.myCursorOffset;
        n = 31 * n + (int)(this.myCursorId >> 32);
        n = 31 * n + (int)this.myCursorId;
        n = 31 * n + this.myResults.hashCode();
        return n;
    }

    public boolean isAwaitCapable() {
        return this.myAwaitCapable;
    }

    public boolean isCursorNotFound() {
        return this.myCursorNotFound;
    }

    public boolean isQueryFailed() {
        return this.myQueryFailed;
    }

    public boolean isShardConfigStale() {
        return this.myShardConfigStale;
    }

    @Override
    public int size() {
        int n = 36;
        for (Document document : this.myResults) {
            n = (int)((long)n + document.size());
        }
        return n;
    }

    @Override
    public void validateSize(int n) throws DocumentToLargeException {
    }

    @Override
    public void write(int n, BsonOutputStream bsonOutputStream) throws IOException {
        int n2 = this.computeFlags();
        int n3 = 16;
        n3 += 4;
        n3 += 8;
        n3 += 4;
        n3 += 4;
        for (Document document : this.myResults) {
            n3 = (int)((long)n3 + document.size());
        }
        this.writeHeader(bsonOutputStream, n, this.myResponseToId, Operation.REPLY, n3);
        bsonOutputStream.writeInt(n2);
        bsonOutputStream.writeLong(this.myCursorId);
        bsonOutputStream.writeInt(this.myCursorOffset);
        bsonOutputStream.writeInt(this.myResults.size());
        for (Document document : this.myResults) {
            bsonOutputStream.writeDocument(document);
        }
    }

    @Override
    public void write(int n, BufferingBsonOutputStream bufferingBsonOutputStream) throws IOException {
        int n2 = this.computeFlags();
        long l = this.writeHeader(bufferingBsonOutputStream, n, this.myResponseToId, Operation.REPLY);
        bufferingBsonOutputStream.writeInt(n2);
        bufferingBsonOutputStream.writeLong(this.myCursorId);
        bufferingBsonOutputStream.writeInt(this.myCursorOffset);
        bufferingBsonOutputStream.writeInt(this.myResults.size());
        for (Document document : this.myResults) {
            bufferingBsonOutputStream.writeDocument(document);
        }
        this.finishHeader(bufferingBsonOutputStream, l);
        bufferingBsonOutputStream.flushBuffer();
    }

    private int computeFlags() {
        int n = 0;
        if (this.myAwaitCapable) {
            n += 8;
        }
        if (this.myCursorNotFound) {
            ++n;
        }
        if (this.myQueryFailed) {
            n += 2;
        }
        if (this.myShardConfigStale) {
            n += 4;
        }
        return n;
    }
}

