/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.message;

import com.allanbank.mongodb.LockType;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.callback.ReplyCallback;
import com.allanbank.mongodb.client.message.PendingMessage;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class PendingMessageQueue {
    public static final long MAX_MESSAGE_ID_MASK = 0xFFFFFFFL;
    public static final int MAX_SIZE = 0x100000;
    public static final long SPIN_TIME_NS = TimeUnit.MILLISECONDS.toNanos(1L) / 100L;
    public static final long YIELD_TIME_NS = TimeUnit.MILLISECONDS.toNanos(1L) >> 1;
    private static final int SPIN_ITERATIONS = 10000;
    private final Condition myCondition;
    private final Lock myLock;
    private final LockType myLockType;
    private final AtomicInteger myLooped;
    private final int myMask;
    private final PendingMessage[] myQueue;
    private final AtomicInteger myReadyBeforePosition;
    private final AtomicInteger myReservePosition;
    private volatile int myTakePosition;
    private final AtomicInteger myWaiting;

    public PendingMessageQueue(int n, LockType lockType) {
        int n2 = n;
        if (0x100000 < n) {
            n2 = 0x100000;
        } else if (Integer.bitCount(n) != 1) {
            for (n2 = 1; n2 < n && n2 != 0; n2 <<= 1) {
            }
        }
        this.myLockType = lockType;
        this.myQueue = new PendingMessage[n2];
        for (int i = 0; i < this.myQueue.length; ++i) {
            this.myQueue[i] = new PendingMessage(0, null);
        }
        this.myMask = n2 - 1;
        this.myLooped = new AtomicInteger(0);
        this.myTakePosition = -1;
        this.myReadyBeforePosition = new AtomicInteger(0);
        this.myReservePosition = new AtomicInteger(0);
        this.myWaiting = new AtomicInteger(0);
        this.myLock = new ReentrantLock();
        this.myCondition = this.myLock.newCondition();
    }

    public int capacity() {
        return this.myQueue.length - 1;
    }

    public void drainTo(List<PendingMessage> list) {
        PendingMessage pendingMessage = new PendingMessage();
        while (this.poll(pendingMessage)) {
            list.add(pendingMessage);
            pendingMessage = new PendingMessage();
        }
    }

    public boolean isEmpty() {
        int n = this.myTakePosition;
        int n2 = this.myReadyBeforePosition.get();
        return n2 == n || n < 0;
    }

    public boolean offer(Message message, ReplyCallback replyCallback) {
        int n = this.myLooped.get();
        int n2 = this.offer();
        if (n2 < 0) {
            return false;
        }
        int n3 = this.toMessageId(n, n2);
        this.myQueue[n2].set(n3, message, replyCallback);
        this.markReady(n2);
        return true;
    }

    public boolean offer(PendingMessage pendingMessage) {
        int n = this.offer();
        if (n < 0) {
            return false;
        }
        this.myQueue[n].set(pendingMessage);
        this.markReady(n);
        return true;
    }

    public boolean poll(PendingMessage pendingMessage) {
        boolean bl = false;
        int n = this.myTakePosition;
        if (this.myReadyBeforePosition.get() != n && n >= 0) {
            pendingMessage.set(this.myQueue[n]);
            this.myQueue[n].clear();
            bl = true;
            this.myTakePosition = this.increment(n);
            this.notifyWaiters(false);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Message message, ReplyCallback replyCallback) throws InterruptedException {
        int n = this.myLooped.get();
        int n2 = this.offer();
        if (n2 < 0) {
            try {
                this.myWaiting.incrementAndGet();
                this.myLock.lock();
                n = this.myLooped.get();
                n2 = this.offer();
                while (n2 < 0) {
                    this.myCondition.await();
                    n = this.myLooped.get();
                    n2 = this.offer();
                }
            }
            finally {
                this.myLock.unlock();
                this.myWaiting.decrementAndGet();
            }
        }
        int n3 = this.toMessageId(n, n2);
        this.myQueue[n2].set(n3, message, replyCallback);
        this.markReady(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Message message, ReplyCallback replyCallback, Message message2, ReplyCallback replyCallback2) throws InterruptedException {
        int n = this.myLooped.get();
        int n2 = this.offer2();
        if (n2 < 0) {
            try {
                this.myWaiting.incrementAndGet();
                this.myLock.lock();
                n = this.myLooped.get();
                n2 = this.offer2();
                while (n2 < 0) {
                    this.myCondition.await();
                    n = this.myLooped.get();
                    n2 = this.offer2();
                }
            }
            finally {
                this.myLock.unlock();
                this.myWaiting.decrementAndGet();
            }
        }
        int n3 = this.toMessageId(n, n2);
        int n4 = this.toMessageId(n, n2 + 1);
        int n5 = this.increment(n2);
        this.myQueue[n2].set(n3, message, replyCallback);
        this.myQueue[n5].set(n4, message2, replyCallback2);
        this.markReady2(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(PendingMessage pendingMessage) throws InterruptedException {
        int n = this.offer();
        if (n < 0) {
            try {
                this.myWaiting.incrementAndGet();
                this.myLock.lock();
                n = this.offer();
                while (n < 0) {
                    this.myCondition.await();
                    n = this.offer();
                }
            }
            finally {
                this.myLock.unlock();
                this.myWaiting.decrementAndGet();
            }
        }
        this.myQueue[n].set(pendingMessage);
        this.markReady(n);
    }

    public int size() {
        int n = this.myTakePosition;
        int n2 = this.myReadyBeforePosition.get();
        if (n < 0) {
            return 0;
        }
        if (n <= n2) {
            return n2 - n;
        }
        return this.myQueue.length - n + n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void take(PendingMessage pendingMessage) throws InterruptedException {
        if (!this.poll(pendingMessage)) {
            if (this.myLockType == LockType.LOW_LATENCY_SPIN) {
                long l = 0L;
                long l2 = 1L;
                long l3 = 1L;
                while (l < l3) {
                    for (int i = 0; i < 10000; ++i) {
                        if (!this.poll(pendingMessage)) continue;
                        return;
                    }
                    l = System.nanoTime();
                    if (l2 == 1L) {
                        l2 = l + SPIN_TIME_NS;
                        l3 = l + YIELD_TIME_NS;
                        continue;
                    }
                    if (l2 >= l || l >= l3) continue;
                    Thread.yield();
                }
            }
            try {
                this.myWaiting.incrementAndGet();
                this.myLock.lock();
                while (!this.poll(pendingMessage)) {
                    this.myCondition.await();
                }
            }
            finally {
                this.myLock.unlock();
                this.myWaiting.decrementAndGet();
            }
        }
    }

    protected int increment(int n) {
        return n + 1 & this.myMask;
    }

    protected void markReady(int n) {
        int n2 = this.increment(n);
        while (!this.myReadyBeforePosition.compareAndSet(n, n2)) {
            Thread.yield();
        }
        if (n == 0 && this.myTakePosition == -1) {
            this.myTakePosition = n;
        }
        this.notifyWaiters(false);
    }

    protected void markReady2(int n) {
        int n2 = this.increment(n);
        int n3 = this.increment(n2);
        while (!this.myReadyBeforePosition.compareAndSet(n, n3)) {
            Thread.yield();
        }
        if (n == 0 && this.myTakePosition == -1) {
            this.myTakePosition = n;
        }
        this.notifyWaiters(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaiters(boolean bl) {
        if (this.myWaiting.get() > 0) {
            try {
                this.myLock.lock();
                if (bl) {
                    this.myCondition.signalAll();
                } else {
                    this.myCondition.signal();
                }
            }
            finally {
                this.myLock.unlock();
            }
        }
    }

    protected int offer() {
        int n = -1;
        int n2 = this.myReservePosition.get();
        int n3 = this.increment(n2);
        if (this.myTakePosition != n3 && this.myReservePosition.compareAndSet(n2, n3)) {
            n = n2;
            if (n3 < n2) {
                this.myLooped.incrementAndGet();
            }
        }
        return n;
    }

    protected int offer2() {
        int n = -1;
        int n2 = this.myReservePosition.get();
        int n3 = this.increment(n2);
        int n4 = this.increment(n3);
        int n5 = this.myTakePosition;
        if (n5 != n3 && n5 != n4 && this.myReservePosition.compareAndSet(n2, n4)) {
            n = n2;
            if (n4 < n2) {
                this.myLooped.incrementAndGet();
            }
        }
        return n;
    }

    private int toMessageId(int n, long l) {
        long l2 = (long)n * (long)this.myQueue.length;
        if (l2 > 0xFFFFFFFL) {
            this.myLooped.compareAndSet(n, 0);
        }
        return (int)(l2 + l & 0xFFFFFFFL) + 1;
    }
}

