/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.impl.EmptyDocument;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.BufferingBsonOutputStream;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.client.Operation;
import com.allanbank.mongodb.client.VersionRange;
import com.allanbank.mongodb.client.message.AbstractMessage;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.IOException;
import java.util.Iterator;

public class Command
extends AbstractMessage {
    public static final String COMMAND_COLLECTION = "$cmd";
    private static final int HEADROOM = 16384;
    private boolean myAllowJumbo = false;
    private final Document myCommand;
    private final Document myRoutingDocument;

    public Command(String string, String string2, Document document) {
        this(string, string2, document, ReadPreference.PRIMARY);
    }

    public Command(String string, String string2, Document document, Document document2, ReadPreference readPreference, VersionRange versionRange) {
        super(string, string2, readPreference, versionRange);
        this.myCommand = document;
        this.myRoutingDocument = document2;
    }

    public Command(String string, String string2, Document document, ReadPreference readPreference) {
        this(string, string2, document, readPreference, null);
    }

    public Command(String string, String string2, Document document, ReadPreference readPreference, VersionRange versionRange) {
        this(string, string2, document, EmptyDocument.INSTANCE, readPreference, versionRange);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Command command = (Command)object;
            bl = super.equals(object) && this.myCommand.equals(command.myCommand);
        }
        return bl;
    }

    public Document getCommand() {
        return this.myCommand;
    }

    @Override
    public String getOperationName() {
        Iterator iterator = this.myCommand.iterator();
        if (iterator.hasNext()) {
            return ((Element)iterator.next()).getName();
        }
        return "command";
    }

    public Document getRoutingDocument() {
        return this.myRoutingDocument;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + this.myCommand.hashCode();
        return n;
    }

    public boolean isAllowJumbo() {
        return this.myAllowJumbo;
    }

    public void setAllowJumbo(boolean bl) {
        this.myAllowJumbo = bl;
    }

    @Override
    public int size() {
        int n = 34;
        n += StringEncoder.utf8Size(this.myDatabaseName);
        n = (int)((long)n + this.myCommand.size());
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Command[");
        stringBuilder.append(this.getOperationName());
        stringBuilder.append(", db=");
        stringBuilder.append(this.myDatabaseName);
        stringBuilder.append(", collection=");
        stringBuilder.append(this.myCollectionName);
        if (this.getReadPreference() != null) {
            stringBuilder.append(", readPreference=");
            stringBuilder.append(this.getReadPreference());
        }
        if (this.getRequiredVersionRange() != null) {
            stringBuilder.append(", requiredVersionRange=");
            stringBuilder.append(this.getRequiredVersionRange());
        }
        stringBuilder.append("]: ");
        stringBuilder.append(this.myCommand);
        return stringBuilder.toString();
    }

    @Override
    public void validateSize(int n) throws DocumentToLargeException {
        long l = this.myCommand.size();
        if (this.isAllowJumbo()) {
            if ((long)(n + 16384) < l) {
                throw new DocumentToLargeException((int)l, n + 16384, this.myCommand);
            }
        } else if ((long)n < l) {
            throw new DocumentToLargeException((int)l, n, this.myCommand);
        }
    }

    @Override
    public void write(int n, BsonOutputStream bsonOutputStream) throws IOException {
        int n2 = this.computeFlags();
        int n3 = 16;
        n3 += 4;
        n3 += bsonOutputStream.sizeOfCString(this.myDatabaseName, ".", COMMAND_COLLECTION);
        n3 += 4;
        n3 += 4;
        n3 = (int)((long)n3 + this.myCommand.size());
        this.writeHeader(bsonOutputStream, n, 0, Operation.QUERY, n3);
        bsonOutputStream.writeInt(n2);
        bsonOutputStream.writeCString(this.myDatabaseName, ".", COMMAND_COLLECTION);
        bsonOutputStream.writeInt(0);
        bsonOutputStream.writeInt(-1);
        bsonOutputStream.writeDocument(this.myCommand);
    }

    @Override
    public void write(int n, BufferingBsonOutputStream bufferingBsonOutputStream) throws IOException {
        int n2 = this.computeFlags();
        long l = this.writeHeader(bufferingBsonOutputStream, n, 0, Operation.QUERY);
        bufferingBsonOutputStream.writeInt(n2);
        bufferingBsonOutputStream.writeCString(this.myDatabaseName, ".", COMMAND_COLLECTION);
        bufferingBsonOutputStream.writeInt(0);
        bufferingBsonOutputStream.writeInt(-1);
        bufferingBsonOutputStream.writeDocument(this.myCommand);
        this.finishHeader(bufferingBsonOutputStream, l);
        bufferingBsonOutputStream.flushBuffer();
    }

    private int computeFlags() {
        int n = 0;
        if (this.getReadPreference().isSecondaryOk()) {
            n += 4;
        }
        return n;
    }
}

