/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.socket;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.io.BufferingBsonOutputStream;
import com.allanbank.mongodb.bson.io.StringDecoderCache;
import com.allanbank.mongodb.bson.io.StringEncoderCache;
import com.allanbank.mongodb.client.ClusterStats;
import com.allanbank.mongodb.client.ClusterType;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.ReconnectStrategy;
import com.allanbank.mongodb.client.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.client.connection.socket.AbstractSocketConnection;
import com.allanbank.mongodb.client.connection.socket.SocketConnection;
import com.allanbank.mongodb.client.connection.socket.TwoThreadSocketConnection;
import com.allanbank.mongodb.client.message.IsMaster;
import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.client.state.LatencyServerSelector;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerSelector;
import com.allanbank.mongodb.client.state.ServerUpdateCallback;
import com.allanbank.mongodb.client.state.SimpleReconnectStrategy;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;

public class SocketConnectionFactory
implements ProxiedConnectionFactory {
    private static final Log LOG = LogFactory.getLog(SocketConnectionFactory.class);
    private ThreadLocal<Reference<BufferingBsonOutputStream>> myBuffers;
    private final Cluster myCluster;
    private final MongoClientConfiguration myConfig;
    private final ConfigurationListener myConfigListener;
    private final StringDecoderCache myDecoderCache;
    private final StringEncoderCache myEncoderCache;
    private final ServerSelector myServerSelector;

    public SocketConnectionFactory(MongoClientConfiguration mongoClientConfiguration) {
        this.myConfig = mongoClientConfiguration;
        this.myCluster = new Cluster(mongoClientConfiguration, ClusterType.STAND_ALONE);
        this.myServerSelector = new LatencyServerSelector(this.myCluster, true);
        this.myBuffers = new ThreadLocal();
        this.myConfigListener = new ConfigurationListener();
        this.myConfig.addPropertyChangeListener(this.myConfigListener);
        this.myDecoderCache = new StringDecoderCache();
        this.myDecoderCache.setMaxCacheEntries(mongoClientConfiguration.getMaxCachedStringEntries());
        this.myDecoderCache.setMaxCacheLength(mongoClientConfiguration.getMaxCachedStringLength());
        this.myEncoderCache = new StringEncoderCache();
        this.myEncoderCache.setMaxCacheEntries(mongoClientConfiguration.getMaxCachedStringEntries());
        this.myEncoderCache.setMaxCacheLength(mongoClientConfiguration.getMaxCachedStringLength());
    }

    @Override
    public void close() {
        this.myBuffers = null;
        this.myConfig.removePropertyChangeListener(this.myConfigListener);
        this.myDecoderCache.setMaxCacheEntries(0);
        this.myDecoderCache.setMaxCacheLength(0);
    }

    @Override
    public Connection connect() throws IOException {
        ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(this.myConfig.getServerAddresses());
        IOException iOException = null;
        Collections.shuffle(arrayList);
        for (InetSocketAddress inetSocketAddress : arrayList) {
            try {
                Server server = this.myCluster.add(inetSocketAddress);
                Connection connection = this.connect(server, this.myConfig);
                ServerUpdateCallback serverUpdateCallback = new ServerUpdateCallback(server);
                connection.send(new IsMaster(), serverUpdateCallback);
                if (Version.UNKNOWN.equals(server.getVersion())) {
                    try {
                        serverUpdateCallback.get();
                    }
                    catch (ExecutionException executionException) {
                        LOG.debug(executionException, "Could not execute an 'ismaster' command.", new Object[0]);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.debug(interruptedException, "Could not execute an 'ismaster' command.", new Object[0]);
                    }
                }
                return connection;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        throw new IOException("Could not connect to any server: " + arrayList);
    }

    @Override
    public Connection connect(Server server, MongoClientConfiguration mongoClientConfiguration) throws IOException {
        AbstractSocketConnection abstractSocketConnection;
        switch (this.myConfig.getConnectionModel()) {
            case SENDER_RECEIVER_THREAD: {
                abstractSocketConnection = new TwoThreadSocketConnection(server, this.myConfig, this.myEncoderCache, this.myDecoderCache);
                break;
            }
            default: {
                abstractSocketConnection = new SocketConnection(server, this.myConfig, this.myEncoderCache, this.myDecoderCache, this.myBuffers);
            }
        }
        ((AbstractSocketConnection)abstractSocketConnection).start();
        return abstractSocketConnection;
    }

    public Cluster getCluster() {
        return this.myCluster;
    }

    @Override
    public ClusterStats getClusterStats() {
        return this.myCluster;
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.STAND_ALONE;
    }

    @Override
    public ReconnectStrategy getReconnectStrategy() {
        SimpleReconnectStrategy simpleReconnectStrategy = new SimpleReconnectStrategy();
        simpleReconnectStrategy.setConfig(this.myConfig);
        simpleReconnectStrategy.setConnectionFactory(this);
        simpleReconnectStrategy.setSelector(this.myServerSelector);
        simpleReconnectStrategy.setState(this.myCluster);
        return simpleReconnectStrategy;
    }

    protected void configurationChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if ("maxCachedStringEntries".equals(string) && object instanceof Number) {
            this.myDecoderCache.setMaxCacheEntries(((Number)object).intValue());
            this.myEncoderCache.setMaxCacheEntries(((Number)object).intValue());
        } else if ("maxCachedStringLength".equals(string) && object instanceof Number) {
            this.myDecoderCache.setMaxCacheLength(((Number)object).intValue());
            this.myEncoderCache.setMaxCacheLength(((Number)object).intValue());
        }
    }

    protected final class ConfigurationListener
    implements PropertyChangeListener {
        protected ConfigurationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SocketConnectionFactory.this.configurationChanged(propertyChangeEvent);
        }
    }
}

