/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.socket;

import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.client.connection.socket.AbstractSocketConnection;
import com.allanbank.mongodb.error.ConnectionLostException;
import com.allanbank.mongodb.util.IOUtils;
import java.util.logging.Level;

class ReceiveRunnable
implements Runnable {
    private final AbstractSocketConnection mySocketConnection;

    ReceiveRunnable(AbstractSocketConnection abstractSocketConnection) {
        this.mySocketConnection = abstractSocketConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (this.mySocketConnection.isOpen()) {
                try {
                    this.mySocketConnection.doReceiveOne();
                    if (!this.mySocketConnection.isShuttingDown() || !this.mySocketConnection.isIdle()) continue;
                    return;
                }
                catch (MongoDbException mongoDbException) {
                    if (!this.mySocketConnection.isOpen()) return;
                    this.mySocketConnection.myLog.log(Level.WARNING, "Error reading a message: " + mongoDbException.getMessage(), mongoDbException);
                    this.mySocketConnection.shutdown(new ConnectionLostException(mongoDbException), false);
                    return;
                }
            }
        }
        finally {
            IOUtils.close(this.mySocketConnection);
        }
    }
}

