/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.socket;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.RandomAccessOutputStream;
import com.allanbank.mongodb.bson.io.StringDecoderCache;
import com.allanbank.mongodb.bson.io.StringEncoderCache;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.Operation;
import com.allanbank.mongodb.client.VersionRange;
import com.allanbank.mongodb.client.callback.NoOpCallback;
import com.allanbank.mongodb.client.callback.Receiver;
import com.allanbank.mongodb.client.callback.ReplyCallback;
import com.allanbank.mongodb.client.callback.ReplyHandler;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.SocketConnectionListener;
import com.allanbank.mongodb.client.message.AbstractMessage;
import com.allanbank.mongodb.client.message.Delete;
import com.allanbank.mongodb.client.message.GetMore;
import com.allanbank.mongodb.client.message.Header;
import com.allanbank.mongodb.client.message.Insert;
import com.allanbank.mongodb.client.message.IsMaster;
import com.allanbank.mongodb.client.message.KillCursors;
import com.allanbank.mongodb.client.message.PendingMessage;
import com.allanbank.mongodb.client.message.PendingMessageQueue;
import com.allanbank.mongodb.client.message.Query;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.client.message.Update;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.error.ConnectionLostException;
import com.allanbank.mongodb.error.DocumentToLargeException;
import com.allanbank.mongodb.error.ServerVersionException;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.StreamCorruptedException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;

public abstract class AbstractSocketConnection
implements Connection,
Receiver {
    public static final int HEADER_LENGTH = 16;
    protected final BsonInputStream myBsonIn;
    protected final MongoClientConfiguration myConfig;
    protected final StringEncoderCache myEncoderCache;
    protected final PropertyChangeSupport myEventSupport;
    protected final Executor myExecutor;
    protected final InputStream myInput;
    protected final Log myLog;
    protected final AtomicBoolean myOpen;
    protected final BufferedOutputStream myOutput;
    protected final PendingMessageQueue myPendingQueue;
    protected final Server myServer;
    protected final AtomicBoolean myShutdown;
    protected final Socket mySocket;
    private int myIdleTicks = 0;
    private final PendingMessage myPendingMessage = new PendingMessage();
    private final AtomicInteger myReaderNeedsToFlush = new AtomicInteger(0);

    public AbstractSocketConnection(Server server, MongoClientConfiguration mongoClientConfiguration, StringEncoderCache stringEncoderCache, StringDecoderCache stringDecoderCache) throws SocketException, IOException {
        this.myServer = server;
        this.myConfig = mongoClientConfiguration;
        this.myEncoderCache = stringEncoderCache;
        this.myLog = LogFactory.getLog(this.getClass());
        this.myExecutor = mongoClientConfiguration.getExecutor();
        this.myEventSupport = new PropertyChangeSupport(this);
        this.myOpen = new AtomicBoolean(false);
        this.myShutdown = new AtomicBoolean(false);
        this.mySocket = this.openSocket(server, mongoClientConfiguration);
        this.updateSocketWithOptions(mongoClientConfiguration);
        this.myOpen.set(true);
        this.myInput = this.mySocket.getInputStream();
        this.myBsonIn = new BsonInputStream(this.myInput, stringDecoderCache);
        this.myOutput = new BufferedOutputStream(this.mySocket.getOutputStream(), 32768);
        this.myPendingQueue = new PendingMessageQueue(mongoClientConfiguration.getMaxPendingOperationsPerConnection(), mongoClientConfiguration.getLockType());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myEventSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void flush() throws IOException {
        this.myReaderNeedsToFlush.set(0);
        this.myOutput.flush();
    }

    @Override
    public int getPendingCount() {
        return this.myPendingQueue.size();
    }

    @Override
    public String getServerName() {
        return this.myServer.getCanonicalName();
    }

    @Override
    public boolean isAvailable() {
        return this.isOpen() && !this.isShuttingDown();
    }

    @Override
    public boolean isIdle() {
        return this.myPendingQueue.isEmpty();
    }

    @Override
    public boolean isOpen() {
        return this.myOpen.get();
    }

    @Override
    public boolean isShuttingDown() {
        return this.myShutdown.get();
    }

    @Override
    public void raiseErrors(MongoDbException mongoDbException) {
        PendingMessage pendingMessage = new PendingMessage();
        while (this.myPendingQueue.poll(pendingMessage)) {
            this.raiseError(mongoDbException, pendingMessage.getReplyCallback());
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myEventSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void shutdown(boolean bl) {
        this.myShutdown.set(true);
        if (bl) {
            IOUtils.close(this);
        } else if (this.isOpen()) {
            this.send(new IsMaster(), new NoOpCallback());
        }
    }

    public abstract void start();

    public void stop() {
        this.shutdown(false);
    }

    public String toString() {
        return "MongoDB(" + this.mySocket.getLocalPort() + "-->" + this.mySocket.getRemoteSocketAddress() + ")";
    }

    @Override
    public void tryReceive() {
        try {
            this.doReceiverFlush();
            if (this.myBsonIn.available() > 0 || this.myInput.available() > 0) {
                this.doReceiveOne();
            }
        }
        catch (IOException iOException) {
            this.myLog.info("Received an error when checking for pending messages: {}.", iOException.getMessage());
        }
    }

    @Override
    public void waitForClosed(int n, TimeUnit timeUnit) {
        long l = System.currentTimeMillis();
        long l2 = l + timeUnit.toMillis(n);
        while (this.isOpen() && l < l2) {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.hashCode();
            }
            l = System.currentTimeMillis();
        }
    }

    protected Message doReceive() throws MongoDbException {
        try {
            int n;
            try {
                n = this.readIntSuppressTimeoutOnNonFirstByte();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                return null;
            }
            this.myBsonIn.prefetch(n - 4);
            int n2 = this.myBsonIn.readInt();
            int n3 = this.myBsonIn.readInt();
            int n4 = this.myBsonIn.readInt();
            Operation operation = Operation.fromCode(n4);
            if (operation == null) {
                throw new MongoDbException("Unexpected operation read '" + n4 + "'.");
            }
            Header header = new Header(n, n2, n3, operation);
            AbstractMessage abstractMessage = null;
            switch (operation) {
                case REPLY: {
                    abstractMessage = new Reply(header, this.myBsonIn);
                    break;
                }
                case QUERY: {
                    abstractMessage = new Query(header, this.myBsonIn);
                    break;
                }
                case UPDATE: {
                    abstractMessage = new Update(this.myBsonIn);
                    break;
                }
                case INSERT: {
                    abstractMessage = new Insert(header, this.myBsonIn);
                    break;
                }
                case GET_MORE: {
                    abstractMessage = new GetMore(this.myBsonIn);
                    break;
                }
                case DELETE: {
                    abstractMessage = new Delete(this.myBsonIn);
                    break;
                }
                case KILL_CURSORS: {
                    abstractMessage = new KillCursors(this.myBsonIn);
                }
            }
            this.myServer.incrementRepliesReceived();
            return abstractMessage;
        }
        catch (IOException iOException) {
            ConnectionLostException connectionLostException = new ConnectionLostException(iOException);
            this.shutdown(connectionLostException, iOException instanceof InterruptedIOException);
            throw connectionLostException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceiveOne() {
        this.doReceiverFlush();
        Message message = this.doReceive();
        if (message instanceof Reply) {
            this.myIdleTicks = 0;
            Reply reply = (Reply)message;
            int n = reply.getResponseToId();
            boolean bl = false;
            try {
                bl = this.myPendingQueue.poll(this.myPendingMessage);
                while (bl && this.myPendingMessage.getMessageId() != n) {
                    MongoDbException mongoDbException = new MongoDbException("No reply received.");
                    this.raiseError(mongoDbException, this.myPendingMessage.getReplyCallback());
                    bl = this.myPendingQueue.poll(this.myPendingMessage);
                }
                if (bl) {
                    this.reply(reply, this.myPendingMessage);
                }
                this.myLog.warn("Could not find the callback for reply '{}'.", n);
            }
            finally {
                this.myPendingMessage.clear();
            }
        } else if (message != null) {
            this.myLog.warn("Received a non-Reply message: {}.", message);
            this.shutdown(new ConnectionLostException(new StreamCorruptedException("Received a non-Reply message: " + message)), false);
        } else {
            ++this.myIdleTicks;
            if (this.myConfig.getMaxIdleTickCount() <= this.myIdleTicks) {
                this.shutdown(false);
            }
        }
    }

    protected void doSend(int n, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        randomAccessOutputStream.writeTo(this.myOutput);
        randomAccessOutputStream.reset();
        this.myServer.incrementMessagesSent();
    }

    protected void markReaderNeedsToFlush() {
        this.myReaderNeedsToFlush.incrementAndGet();
    }

    protected void raiseError(Throwable throwable, ReplyCallback replyCallback) {
        ReplyHandler.raiseError(throwable, replyCallback, this.myExecutor);
    }

    protected int readIntSuppressTimeoutOnNonFirstByte() throws EOFException, IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = this.myBsonIn.read();
        n2 |= n;
        n3 += n << 0;
        for (int i = 8; i < 32; i += 8) {
            try {
                n = this.myBsonIn.read();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new IOException(socketTimeoutException);
            }
            n2 |= n;
            n3 += n << i;
        }
        if (n2 < 0) {
            throw new EOFException("Remote connection closed: " + this.mySocket.getRemoteSocketAddress());
        }
        return n3;
    }

    protected void reply(Reply reply, PendingMessage pendingMessage) {
        long l = pendingMessage.latency();
        if (l > 0L) {
            this.myServer.updateAverageLatency(l);
        }
        ReplyCallback replyCallback = pendingMessage.getReplyCallback();
        ReplyHandler.reply(this, reply, replyCallback, this.myExecutor);
    }

    protected final void send(PendingMessage pendingMessage, RandomAccessOutputStream randomAccessOutputStream) throws InterruptedException, IOException {
        int n = pendingMessage.getMessageId();
        pendingMessage.timestampNow();
        if (pendingMessage.getReplyCallback() != null && !this.myPendingQueue.offer(pendingMessage)) {
            this.flush();
            this.myPendingQueue.put(pendingMessage);
        }
        this.doSend(n, randomAccessOutputStream);
        if (this.myShutdown.get()) {
            this.flush();
        }
    }

    protected void shutdown(MongoDbException mongoDbException, boolean bl) {
        if (bl) {
            this.myServer.connectionTerminated();
        }
        PendingMessage pendingMessage = new PendingMessage();
        while (this.myPendingQueue.poll(pendingMessage)) {
            this.raiseError(mongoDbException, pendingMessage.getReplyCallback());
        }
        this.closeQuietly();
    }

    protected void updateSocketWithOptions(MongoClientConfiguration mongoClientConfiguration) throws SocketException {
        block2: {
            this.mySocket.setKeepAlive(mongoClientConfiguration.isUsingSoKeepalive());
            this.mySocket.setSoTimeout(mongoClientConfiguration.getReadTimeout());
            try {
                this.mySocket.setTcpNoDelay(true);
            }
            catch (SocketException socketException) {
                if ("AFUNIXSocketException".equals(socketException.getClass().getSimpleName())) break block2;
                throw socketException;
            }
        }
        this.mySocket.setPerformancePreferences(1, 5, 6);
    }

    protected void validate(Message message, Message message2) throws DocumentToLargeException, ServerVersionException {
        Version version = this.myServer.getVersion();
        int n = this.myServer.getMaxBsonObjectSize();
        message.validateSize(n);
        this.validateVersion(message, version);
        if (message2 != null) {
            message2.validateSize(n);
            this.validateVersion(message, version);
        }
    }

    private void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            this.myLog.warn(iOException, "I/O exception trying to shutdown the connection.", new Object[0]);
        }
    }

    private void doReceiverFlush() {
        try {
            int n = this.myReaderNeedsToFlush.get();
            if (n != 0 && this.myPendingQueue.size() <= n) {
                this.flush();
            }
        }
        catch (IOException iOException) {
            this.myLog.warn("Error flushing data to the server: " + iOException.getMessage());
        }
    }

    private Socket openSocket(Server server, MongoClientConfiguration mongoClientConfiguration) throws IOException {
        SocketFactory socketFactory = mongoClientConfiguration.getSocketFactory();
        IOException iOException = null;
        Socket socket = null;
        for (InetSocketAddress inetSocketAddress : this.myServer.getAddresses()) {
            try {
                socket = socketFactory.createSocket();
                socket.connect(inetSocketAddress, mongoClientConfiguration.getConnectTimeout());
                if (socketFactory instanceof SocketConnectionListener) {
                    ((SocketConnectionListener)((Object)socketFactory)).connected(inetSocketAddress, socket);
                }
                server.connectionOpened(inetSocketAddress);
                iOException = null;
                break;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                try {
                    if (socket == null) continue;
                    socket.close();
                }
                catch (IOException iOException3) {
                    this.myLog.info("Could not close the defunct socket connection: {}", socket);
                }
            }
        }
        if (iOException != null) {
            server.connectFailed();
            throw iOException;
        }
        return socket;
    }

    private void validateVersion(Message message, Version version) throws ServerVersionException {
        VersionRange versionRange = message.getRequiredVersionRange();
        if (versionRange != null && !versionRange.contains(version)) {
            throw new ServerVersionException(message.getOperationName(), versionRange, version, message);
        }
    }
}

