/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.rs;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.proxy.ConnectionInfo;
import com.allanbank.mongodb.client.connection.rs.ReplicaSetConnection;
import com.allanbank.mongodb.client.message.IsMaster;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.client.state.AbstractReconnectStrategy;
import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerUpdateCallback;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class ReplicaSetReconnectStrategy
extends AbstractReconnectStrategy {
    public static final int INITIAL_RECONNECT_PAUSE_TIME_MS = 10;
    public static final int MAX_RECONNECT_PAUSE_TIME_MS = 1000;
    protected static final Log LOG = LogFactory.getLog(ReplicaSetReconnectStrategy.class);
    private final Set<Server> myDeadServers = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public ReplicaSetConnection reconnect(Connection connection) {
        ConnectionInfo<Server> connectionInfo = this.reconnectPrimary();
        if (connectionInfo != null) {
            return new ReplicaSetConnection(connectionInfo.getConnection(), connectionInfo.getConnectionKey(), this.getState(), this.getConnectionFactory(), this.getConfig(), this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConnectionInfo<Server> reconnectPrimary() {
        LOG.debug("Trying replica set reconnect.");
        Cluster cluster = this.getState();
        int n = this.getConfig().getReconnectTimeout();
        long l = System.currentTimeMillis();
        long l2 = n <= 0 ? Long.MAX_VALUE : l + (long)n;
        HashMap<Server, Future<Reply>> hashMap = new HashMap<Server, Future<Reply>>();
        HashMap<Server, Connection> hashMap2 = new HashMap<Server, Connection>();
        boolean bl = Thread.interrupted();
        try {
            for (Server object : cluster.getWritableServers()) {
                if (!this.verifyPutative(hashMap, hashMap2, object, l2)) continue;
                LOG.debug("New primary for replica set: {}.", object.getCanonicalName());
                ConnectionInfo<Server> connectionInfo = this.createReplicaSetConnection(hashMap2, object);
                return connectionInfo;
            }
            int n2 = 10;
            while (l < l2) {
                for (Server server : cluster.getServers()) {
                    this.sendIsPrimary(hashMap, hashMap2, server, false);
                    ConnectionInfo<Server> connectionInfo = this.checkForReply(cluster, hashMap, hashMap2, l2);
                    if (connectionInfo == null) continue;
                    ConnectionInfo<Server> connectionInfo2 = connectionInfo;
                    return connectionInfo2;
                }
                this.sleep(n2, TimeUnit.MILLISECONDS);
                n2 = Math.min(1000, n2 + n2);
                ConnectionInfo<Server> connectionInfo = this.checkForReply(cluster, hashMap, hashMap2, l2);
                if (connectionInfo != null) {
                    ConnectionInfo<Server> connectionInfo3 = connectionInfo;
                    return connectionInfo3;
                }
                l = System.currentTimeMillis();
            }
        }
        finally {
            for (Connection connection : hashMap2.values()) {
                connection.shutdown(true);
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    protected ConnectionInfo<Server> checkForReply(Cluster cluster, Map<Server, Future<Reply>> map, Map<Server, Connection> map2, long l) {
        HashMap<Server, Future<Reply>> hashMap = new HashMap<Server, Future<Reply>>(map);
        for (Map.Entry entry : hashMap.entrySet()) {
            Server server = (Server)entry.getKey();
            Future future = (Future)entry.getValue();
            if (future.isDone()) {
                Server server2;
                map.remove(server);
                String string = this.checkReply(future, map2, server, l);
                if (string == null || !this.verifyPutative(map, map2, server2 = this.getState().get(string), l)) continue;
                LOG.info("New primary for replica set: {}", string);
                this.updateUnknown(cluster, map, map2);
                return this.createReplicaSetConnection(map2, server2);
            }
            LOG.debug("No reply yet from {}.", server);
        }
        return null;
    }

    protected String checkReply(Future<Reply> future, Map<Server, Connection> map, Server server, long l) {
        if (future != null) {
            try {
                Document document;
                Element element;
                Reply reply = future.get(Math.max(0L, l - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
                List<Document> list = reply.getResults();
                if (!list.isEmpty() && (element = (document = list.get(0)).get("primary")) instanceof StringElement) {
                    return ((StringElement)element).getValue();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (TimeoutException timeoutException) {
                Connection connection = map.remove(server);
                IOUtils.close(connection);
            }
            catch (ExecutionException executionException) {
                Connection connection = map.remove(server);
                IOUtils.close(connection);
            }
        }
        return null;
    }

    protected Future<Reply> sendIsPrimary(Map<Server, Future<Reply>> map, Map<Server, Connection> map2, Server server, boolean bl) {
        ServerUpdateCallback serverUpdateCallback = null;
        try {
            Connection connection = map2.get(server);
            if (connection == null || !connection.isAvailable()) {
                connection = this.getConnectionFactory().connect(server, this.getConfig());
                map2.put(server, connection);
            }
            if ((serverUpdateCallback = map.get(server)) == null) {
                LOG.debug("Sending reconnect(rs) query to {}.", server.getCanonicalName());
                ServerUpdateCallback serverUpdateCallback2 = new ServerUpdateCallback(server);
                connection.send(new IsMaster(), serverUpdateCallback2);
                serverUpdateCallback = serverUpdateCallback2;
                map.put(server, serverUpdateCallback);
                this.myDeadServers.remove(server);
            }
        }
        catch (IOException iOException) {
            Level level = bl && this.myDeadServers.add(server) ? Level.WARNING : Level.FINE;
            LOG.log(level, iOException, "Cannot create a connection to '{}'.", server);
        }
        return serverUpdateCallback;
    }

    protected void sleep(int n, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected boolean verifyPutative(Map<Server, Future<Reply>> map, Map<Server, Connection> map2, Server server, long l) {
        LOG.debug("Verify putative server ({}) on reconnect(rs).", server);
        map.remove(server);
        Future<Reply> future = this.sendIsPrimary(map, map2, server, true);
        String string = this.checkReply(future, map2, server, l);
        return server.getCanonicalName().equals(string);
    }

    private ConnectionInfo<Server> createReplicaSetConnection(Map<Server, Connection> map, Server server) {
        Connection connection = map.remove(server);
        return new ConnectionInfo<Server>(connection, server);
    }

    private void updateUnknown(Cluster cluster, Map<Server, Future<Reply>> map, Map<Server, Connection> map2) {
        for (Server server : cluster.getServers()) {
            switch (server.getState()) {
                case UNKNOWN: 
                case UNAVAILABLE: {
                    map.remove(server);
                    this.sendIsPrimary(map, map2, server, false);
                    break;
                }
            }
        }
    }
}

