/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.rs;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.client.ClusterStats;
import com.allanbank.mongodb.client.ClusterType;
import com.allanbank.mongodb.client.callback.FutureReplyCallback;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.ConnectionFactory;
import com.allanbank.mongodb.client.connection.ReconnectStrategy;
import com.allanbank.mongodb.client.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.client.connection.rs.ReplicaSetConnection;
import com.allanbank.mongodb.client.connection.rs.ReplicaSetReconnectStrategy;
import com.allanbank.mongodb.client.message.IsMaster;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.client.state.Cluster;
import com.allanbank.mongodb.client.state.ClusterPinger;
import com.allanbank.mongodb.client.state.LatencyServerSelector;
import com.allanbank.mongodb.client.state.Server;
import com.allanbank.mongodb.client.state.ServerUpdateCallback;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

public class ReplicaSetConnectionFactory
implements ConnectionFactory {
    protected static final Log LOG = LogFactory.getLog(ReplicaSetConnectionFactory.class);
    protected final ProxiedConnectionFactory myConnectionFactory;
    private final Cluster myCluster;
    private final MongoClientConfiguration myConfig;
    private final ClusterPinger myPinger;
    private final ReplicaSetReconnectStrategy myStrategy;

    public ReplicaSetConnectionFactory(ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        this.myConnectionFactory = proxiedConnectionFactory;
        this.myConfig = mongoClientConfiguration;
        this.myCluster = new Cluster(mongoClientConfiguration, ClusterType.REPLICA_SET);
        this.myPinger = new ClusterPinger(this.myCluster, proxiedConnectionFactory, mongoClientConfiguration);
        this.myStrategy = new ReplicaSetReconnectStrategy();
        this.myStrategy.setConfig(this.myConfig);
        this.myStrategy.setConnectionFactory(this.myConnectionFactory);
        this.myStrategy.setState(this.myCluster);
        this.myStrategy.setSelector(new LatencyServerSelector(this.myCluster, false));
        this.bootstrap();
    }

    public void bootstrap() {
        this.locatePrimary();
        this.myPinger.initialSweep(this.myCluster);
        this.myPinger.start();
    }

    @Override
    public void close() {
        IOUtils.close(this.myPinger);
        IOUtils.close(this.myConnectionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect() throws IOException {
        List<Server> list = this.myCluster.getWritableServers();
        for (int i = 0; i < 10; ++i) {
            for (Server server : list) {
                Connection connection;
                block6: {
                    ReplicaSetConnection replicaSetConnection;
                    connection = null;
                    try {
                        connection = this.myConnectionFactory.connect(server, this.myConfig);
                        if (!this.isWritable(server, connection)) break block6;
                        ReplicaSetConnection replicaSetConnection2 = new ReplicaSetConnection(connection, server, this.myCluster, this.myConnectionFactory, this.myConfig, this.myStrategy);
                        connection = null;
                        replicaSetConnection = replicaSetConnection2;
                    }
                    catch (IOException iOException) {
                        try {
                            LOG.debug(iOException, "Error connecting to presumptive primary: {}", iOException.getMessage());
                        }
                        catch (Throwable throwable) {
                            IOUtils.close(connection);
                            throw throwable;
                        }
                        IOUtils.close(connection);
                        continue;
                    }
                    IOUtils.close(connection);
                    return replicaSetConnection;
                }
                IOUtils.close(connection);
                break;
            }
            list = this.locatePrimary();
        }
        return new ReplicaSetConnection(null, null, this.myCluster, this.myConnectionFactory, this.myConfig, this.myStrategy);
    }

    @Override
    public ClusterStats getClusterStats() {
        return this.myCluster;
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.REPLICA_SET;
    }

    @Override
    public ReconnectStrategy getReconnectStrategy() {
        return this.myStrategy;
    }

    protected Cluster getCluster() {
        return this.myCluster;
    }

    protected boolean isWritable(Server server, Connection connection) {
        try {
            Document document;
            StringElement stringElement;
            ServerUpdateCallback serverUpdateCallback = new ServerUpdateCallback(server);
            connection.send(new IsMaster(), serverUpdateCallback);
            Reply reply = (Reply)serverUpdateCallback.get();
            List<Document> list = reply.getResults();
            if (!list.isEmpty() && (stringElement = (document = list.get(0)).get(StringElement.class, "primary")) != null) {
                return stringElement.getValue().equals(connection.getServerName());
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.debug(interruptedException, "Failure testing if a connection is writable: {}", interruptedException.getMessage());
        }
        catch (ExecutionException executionException) {
            LOG.debug(executionException, "Failure testing if a connection is writable: {}", executionException.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Server> locatePrimary() {
        for (InetSocketAddress inetSocketAddress : this.myConfig.getServerAddresses()) {
            Connection connection = null;
            FutureReplyCallback futureReplyCallback = new FutureReplyCallback();
            try {
                Object object;
                Object object2;
                Server server = this.myCluster.add(inetSocketAddress);
                connection = this.myConnectionFactory.connect(server, this.myConfig);
                connection.send(new IsMaster(), futureReplyCallback);
                Reply reply = (Reply)futureReplyCallback.get();
                List<Document> list = reply.getResults();
                if (list.isEmpty()) continue;
                Document document = list.get(0);
                if (this.myConfig.isAutoDiscoverServers()) {
                    object2 = document.find(StringElement.class, "hosts", ".*");
                    object = object2.iterator();
                    while (object.hasNext()) {
                        StringElement stringElement = (StringElement)object.next();
                        this.myCluster.add(stringElement.getValue());
                    }
                }
                if ((object2 = document.findFirst(StringElement.class, "primary")) == null) continue;
                object = Collections.singletonList(this.myCluster.add(((StringElement)object2).getValue()));
                return object;
            }
            catch (IOException iOException) {
                LOG.warn(iOException, "I/O error during replica-set bootstrap to {}.", inetSocketAddress);
            }
            catch (MongoDbException mongoDbException) {
                LOG.warn(mongoDbException, "MongoDB error during replica-set bootstrap to {}.", inetSocketAddress);
            }
            catch (InterruptedException interruptedException) {
                LOG.warn(interruptedException, "Interrupted during replica-set bootstrap to {}.", inetSocketAddress);
            }
            catch (ExecutionException executionException) {
                LOG.warn(executionException, "Error during replica-set bootstrap to {}.", inetSocketAddress);
            }
            finally {
                IOUtils.close(connection, Level.WARNING, "I/O error shutting down replica-set bootstrap connection to " + inetSocketAddress + ".");
            }
        }
        return Collections.emptyList();
    }
}

