/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.connection.auth;

import com.allanbank.mongodb.Credential;
import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.callback.ReplyCallback;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.auth.Authenticator;
import com.allanbank.mongodb.client.connection.proxy.AbstractProxyConnection;
import com.allanbank.mongodb.error.MongoDbAuthenticationException;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AuthenticatingConnection
extends AbstractProxyConnection {
    public static final String ADMIN_DB_NAME = "admin";
    public static final Log LOG = LogFactory.getLog(AuthenticatingConnection.class);
    private final Map<String, Authenticator> myAuthenticators = new ConcurrentHashMap<String, Authenticator>();
    private final Map<String, MongoDbException> myFailures = new ConcurrentHashMap<String, MongoDbException>();

    public AuthenticatingConnection(Connection connection, MongoClientConfiguration mongoClientConfiguration) {
        super(connection);
        Collection<Credential> collection = mongoClientConfiguration.getCredentials();
        for (Credential credential : collection) {
            Authenticator authenticator = credential.authenticator();
            authenticator.startAuthentication(credential, connection);
            if (collection.size() > 1) {
                try {
                    if (authenticator.result()) continue;
                    this.myFailures.put(credential.getDatabase(), new MongoDbAuthenticationException("Authentication failed for the " + credential.getDatabase() + " database."));
                }
                catch (MongoDbException mongoDbException) {
                    this.myFailures.put(credential.getDatabase(), mongoDbException);
                }
                continue;
            }
            this.myAuthenticators.put(credential.getDatabase(), authenticator);
        }
    }

    @Override
    public void send(Message message, Message message2, ReplyCallback replyCallback) throws MongoDbException {
        this.ensureAuthenticated(message);
        this.ensureAuthenticated(message2);
        super.send(message, message2, replyCallback);
    }

    @Override
    public void send(Message message, ReplyCallback replyCallback) throws MongoDbException {
        this.ensureAuthenticated(message);
        super.send(message, replyCallback);
    }

    public String toString() {
        return "Auth(" + this.getProxiedConnection() + ")";
    }

    @Override
    protected Connection getProxiedConnection() {
        Connection connection = super.getProxiedConnection();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureAuthenticated(Message message) throws MongoDbAuthenticationException {
        if (!this.myAuthenticators.isEmpty()) {
            Iterator<Map.Entry<String, Authenticator>> iterator = this.myAuthenticators.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Authenticator> entry = iterator.next();
                try {
                    if (entry.getValue().result()) continue;
                    this.myFailures.put(entry.getKey(), new MongoDbAuthenticationException("Authentication failed for the " + entry.getKey() + " database."));
                }
                catch (MongoDbException mongoDbException) {
                    LOG.warn(mongoDbException, "Authentication failed: []", mongoDbException.getMessage());
                    this.myFailures.put(entry.getKey(), mongoDbException);
                }
                finally {
                    iterator.remove();
                }
            }
        }
        if (this.myFailures.containsKey(message.getDatabaseName())) {
            throw new MongoDbAuthenticationException(this.myFailures.get(message.getDatabaseName()));
        }
    }
}

