/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.callback;

import com.allanbank.mongodb.MongoCursorControl;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.StreamCallback;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.callback.AbstractValidatingReplyCallback;
import com.allanbank.mongodb.client.callback.AddressAware;
import com.allanbank.mongodb.client.callback.CommandCursorTranslator;
import com.allanbank.mongodb.client.message.CursorableMessage;
import com.allanbank.mongodb.client.message.GetMore;
import com.allanbank.mongodb.client.message.KillCursors;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.error.ReplyException;
import java.util.List;

public final class CursorStreamingCallback
extends AbstractValidatingReplyCallback
implements MongoCursorControl,
AddressAware {
    private volatile String myAddress;
    private int myBatchSize;
    private final Client myClient;
    private volatile boolean myClosed = false;
    private final String myCollectionName;
    private boolean myCommand;
    private long myCursorId = 0L;
    private final String myDatabaseName;
    private final StreamCallback<Document> myForwardCallback;
    private int myLimit = 0;
    private final CursorableMessage myMessage;
    private volatile Reply myReply;
    private boolean myShutdown = false;

    public CursorStreamingCallback(Client client, CursorableMessage cursorableMessage, boolean bl, StreamCallback<Document> streamCallback) {
        this.myClient = client;
        this.myDatabaseName = cursorableMessage.getDatabaseName();
        this.myCollectionName = cursorableMessage.getCollectionName();
        this.myBatchSize = cursorableMessage.getBatchSize();
        this.myMessage = cursorableMessage;
        this.myCommand = bl;
        this.myForwardCallback = streamCallback;
        this.myLimit = cursorableMessage.getLimit();
    }

    public CursorStreamingCallback(Client client, Document document, StreamCallback<Document> streamCallback) {
        String string;
        String string2 = string = document.get(StringElement.class, "ns").getValue();
        String string3 = string;
        int n = string.indexOf(46);
        if (0 < n) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        this.myMessage = null;
        this.myCommand = false;
        this.myClient = client;
        this.myDatabaseName = string2;
        this.myCollectionName = string3;
        this.myForwardCallback = streamCallback;
        this.myCursorId = document.get(NumericElement.class, "cursor_id").getLongValue();
        this.myLimit = document.get(NumericElement.class, "limit").getIntValue();
        this.myBatchSize = document.get(NumericElement.class, "batch_size").getIntValue();
        this.myAddress = document.get(StringElement.class, "server").getValue();
    }

    @Override
    public Document asDocument() {
        long l = this.myCursorId;
        if (l != 0L) {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            documentBuilder.add("ns", this.myDatabaseName + "." + this.myCollectionName);
            documentBuilder.add("cursor_id", l);
            documentBuilder.add("server", this.myAddress);
            documentBuilder.add("limit", this.myLimit);
            documentBuilder.add("batch_size", this.myBatchSize);
            return documentBuilder.build();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StreamCallback<Document> streamCallback = this.myForwardCallback;
        synchronized (streamCallback) {
            this.myClosed = true;
            this.sendKill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(Throwable throwable) {
        try {
            StreamCallback<Document> streamCallback = this.myForwardCallback;
            synchronized (streamCallback) {
                this.myForwardCallback.exception(throwable);
            }
        }
        finally {
            this.close();
        }
    }

    public String getAddress() {
        return this.myAddress;
    }

    @Override
    public int getBatchSize() {
        return this.myBatchSize;
    }

    public Client getClient() {
        return this.myClient;
    }

    public String getCollectionName() {
        return this.myCollectionName;
    }

    public long getCursorId() {
        return this.myCursorId;
    }

    public String getDatabaseName() {
        return this.myDatabaseName;
    }

    public int getLimit() {
        return this.myLimit;
    }

    @Override
    public boolean isLightWeight() {
        return false;
    }

    public void restart() {
        this.sendRequest();
    }

    @Override
    public void setAddress(String string) {
        this.myAddress = string;
        if (this.myReply != null) {
            Reply reply = this.myReply;
            this.myReply = null;
            this.push(reply);
        }
    }

    @Override
    public void setBatchSize(int n) {
        this.myBatchSize = n;
    }

    @Override
    public void stop() {
        this.myShutdown = true;
    }

    @Override
    protected MongoDbException asError(Reply reply, int n, int n2, String string) {
        return new ReplyException(n, n2, string, this.myMessage, reply);
    }

    @Override
    protected void handle(Reply reply) throws MongoDbException {
        Reply reply2 = reply;
        if (this.isCommand()) {
            reply2 = CommandCursorTranslator.translate(reply);
            this.myCommand = false;
        }
        this.myReply = reply2;
        if (this.myAddress != null) {
            this.push(reply2);
        }
    }

    protected boolean isCommand() {
        return this.myCommand;
    }

    protected List<Document> loadDocuments(Reply reply) throws RuntimeException {
        this.myCursorId = reply.getCursorId();
        List<Document> list = reply.getResults();
        if (0 < this.myLimit) {
            if (this.myLimit <= list.size()) {
                list = list.subList(0, this.myLimit);
                this.close();
            }
            this.myLimit -= list.size();
        }
        if (this.myCursorId != 0L && !this.myShutdown) {
            this.sendRequest();
        }
        return list;
    }

    protected int nextBatchSize() {
        if (0 < this.myLimit && this.myLimit <= this.myBatchSize) {
            return this.myLimit;
        }
        return this.myBatchSize;
    }

    protected void sendKill() throws MongoDbException {
        long l = this.myCursorId;
        if (l != 0L && !this.myShutdown) {
            this.myCursorId = 0L;
            this.myClient.send(new KillCursors(new long[]{l}, ReadPreference.server(this.myAddress)), null);
        }
    }

    protected void sendRequest() throws MongoDbException {
        GetMore getMore = new GetMore(this.myDatabaseName, this.myCollectionName, this.myCursorId, this.nextBatchSize(), ReadPreference.server(this.myAddress));
        this.myClient.send(getMore, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(Reply reply) {
        StreamCallback<Document> streamCallback = this.myForwardCallback;
        synchronized (streamCallback) {
            if (this.myClosed) {
                this.myCursorId = reply.getCursorId();
                this.sendKill();
            } else {
                try {
                    for (Document document : this.loadDocuments(reply)) {
                        this.myForwardCallback.callback(document);
                    }
                    if (this.myCursorId == 0L) {
                        this.myForwardCallback.done();
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.exception(runtimeException);
                    this.close();
                }
            }
        }
    }
}

