/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.callback;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.builder.BatchedWrite;
import com.allanbank.mongodb.builder.BatchedWriteMode;
import com.allanbank.mongodb.builder.write.WriteOperation;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.callback.NoOpCallback;
import com.allanbank.mongodb.client.callback.ReplyCallback;
import com.allanbank.mongodb.client.callback.ReplyLongCallback;
import com.allanbank.mongodb.client.message.BatchedWriteCommand;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.error.BatchedWriteException;
import com.allanbank.mongodb.util.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BatchedWriteCallback
extends ReplyLongCallback {
    private final List<BatchedWrite.Bundle> myBundles;
    private Client myClient;
    private final String myCollectionName;
    private final String myDatabaseName;
    private final Map<WriteOperation, Throwable> myFailedOperations;
    private int myFinished;
    private long myN = 0L;
    private final List<BatchedWrite.Bundle> myPendingBundles;
    private final List<Callback<Reply>> myRealCallbacks;
    private List<WriteOperation> mySkippedOperations;
    private final BatchedWrite myWrite;

    public BatchedWriteCallback(String string, String string2, Callback<Long> callback, BatchedWrite batchedWrite, Client client, List<BatchedWrite.Bundle> list) {
        super(callback);
        this.myDatabaseName = string;
        this.myCollectionName = string2;
        this.myWrite = batchedWrite;
        this.myClient = client;
        this.myBundles = Collections.unmodifiableList(new ArrayList<BatchedWrite.Bundle>(list));
        this.myPendingBundles = new LinkedList<BatchedWrite.Bundle>(this.myBundles);
        this.myFinished = 0;
        this.myN = 0L;
        this.myFailedOperations = new IdentityHashMap<WriteOperation, Throwable>();
        this.mySkippedOperations = null;
        this.myRealCallbacks = Collections.emptyList();
    }

    public BatchedWriteCallback(String string, String string2, List<Callback<Reply>> list, BatchedWrite batchedWrite, List<BatchedWrite.Bundle> list2) {
        super((Callback<Long>)null);
        this.myDatabaseName = string;
        this.myCollectionName = string2;
        this.myWrite = batchedWrite;
        this.myClient = null;
        this.myBundles = Collections.unmodifiableList(new ArrayList<BatchedWrite.Bundle>(list2));
        this.myPendingBundles = new LinkedList<BatchedWrite.Bundle>(this.myBundles);
        this.myFinished = 0;
        this.myN = 0L;
        this.myFailedOperations = new IdentityHashMap<WriteOperation, Throwable>();
        this.mySkippedOperations = null;
        this.myRealCallbacks = new ArrayList<Callback<Reply>>(list);
        int n = 0;
        for (BatchedWrite.Bundle bundle : this.myBundles) {
            n += bundle.getWrites().size();
        }
        Assertions.assertThat(this.myRealCallbacks.size() == n, "There nust be an operation (" + n + ") in a bundle for each callback (" + this.myRealCallbacks.size() + ").");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void send() {
        ArrayList arrayList;
        BatchedWriteCallback batchedWriteCallback = this;
        synchronized (batchedWriteCallback) {
            void var3_4;
            List<BatchedWrite.Bundle> object = this.myPendingBundles;
            if (BatchedWriteMode.SERIALIZE_AND_STOP.equals((Object)this.myWrite.getMode())) {
                List<BatchedWrite.Bundle> list = this.myPendingBundles.subList(0, 1);
            }
            arrayList = new ArrayList(var3_4);
            var3_4.clear();
        }
        for (BatchedWrite.Bundle bundle : arrayList) {
            BatchedWriteCommand batchedWriteCommand = new BatchedWriteCommand(this.myDatabaseName, this.myCollectionName, bundle);
            batchedWriteCommand.setAllowJumbo(true);
            if (this.myWrite.getDurability() == Durability.NONE) {
                Document document = BuilderFactory.start().add("ok", 1).add("n", -1).build();
                Reply reply = new Reply(0, 0L, 0, Collections.singletonList(document), false, false, false, false);
                this.myClient.send(batchedWriteCommand, NoOpCallback.NO_OP);
                this.publish(bundle, reply);
                continue;
            }
            this.myClient.send(batchedWriteCommand, new BundleCallback(bundle));
        }
        if (this.myWrite.getDurability() == Durability.NONE && this.myPendingBundles.isEmpty() && this.myForwardCallback != null) {
            this.myForwardCallback.callback(-1L);
        }
    }

    public void setClient(Client client) {
        this.myClient = client;
    }

    protected synchronized void callback(BatchedWrite.Bundle bundle, Reply reply) {
        MongoDbException mongoDbException = this.asError(reply);
        if (mongoDbException != null) {
            this.exception(bundle, mongoDbException);
        } else {
            ++this.myFinished;
            this.myN += this.convert(reply).longValue();
            boolean bl = this.failedDurability(bundle, reply) | this.failedWrites(bundle, reply);
            this.publish(bundle, reply);
            if (bl) {
                this.publishResults();
            } else if (!this.myPendingBundles.isEmpty()) {
                this.send();
            } else if (this.myFinished == this.myBundles.size()) {
                this.publishResults();
            }
        }
    }

    protected synchronized void exception(BatchedWrite.Bundle bundle, Throwable throwable) {
        ++this.myFinished;
        for (WriteOperation writeOperation : bundle.getWrites()) {
            this.myFailedOperations.put(writeOperation, throwable);
        }
        if (this.myWrite.getMode() == BatchedWriteMode.SERIALIZE_AND_STOP) {
            this.publishResults();
        } else if (this.myFinished == this.myBundles.size()) {
            this.publishResults();
        }
    }

    private boolean failedDurability(BatchedWrite.Bundle bundle, Reply reply) {
        Document document;
        DocumentElement documentElement;
        List<Document> list = reply.getResults();
        if (list.size() == 1 && (documentElement = (document = list.get(0)).get(DocumentElement.class, "writeConcernError")) != null) {
            int n = this.toInt(documentElement.get(NumericElement.class, "code"));
            String string = this.asString(documentElement.get(Element.class, "errmsg"));
            MongoDbException mongoDbException = this.asError(reply, 0, n, true, string, null);
            for (WriteOperation writeOperation : bundle.getWrites()) {
                this.myFailedOperations.put(writeOperation, mongoDbException);
            }
        }
        return this.myWrite.getMode() == BatchedWriteMode.SERIALIZE_AND_STOP && !this.myFailedOperations.isEmpty();
    }

    private boolean failedWrites(BatchedWrite.Bundle bundle, Reply reply) {
        Document document;
        ArrayElement arrayElement;
        List<Document> list = reply.getResults();
        if (list.size() == 1 && (arrayElement = (document = list.get(0)).get(ArrayElement.class, "writeErrors")) != null) {
            List<WriteOperation> list2 = bundle.getWrites();
            for (DocumentElement documentElement : arrayElement.find(DocumentElement.class, ".*")) {
                int n = this.toInt(documentElement.get(NumericElement.class, "index"));
                int n2 = this.toInt(documentElement.get(NumericElement.class, "code"));
                String string = this.asString(documentElement.get(Element.class, "errmsg"));
                if (0 > n || n >= list2.size()) continue;
                WriteOperation writeOperation = list2.get(n);
                this.myFailedOperations.put(writeOperation, this.asError(reply, 0, n2, false, string, null));
                if (this.myWrite.getMode() != BatchedWriteMode.SERIALIZE_AND_STOP) continue;
                this.mySkippedOperations = new ArrayList<WriteOperation>();
                this.mySkippedOperations.addAll(list2.subList(n + 1, list2.size()));
            }
        }
        return this.myWrite.getMode() == BatchedWriteMode.SERIALIZE_AND_STOP && !this.myFailedOperations.isEmpty();
    }

    private void publish(BatchedWrite.Bundle bundle, Reply reply) {
        if (this.myForwardCallback == null) {
            int n = 0;
            for (BatchedWrite.Bundle bundle2 : this.myBundles) {
                List<WriteOperation> list = bundle2.getWrites();
                int n2 = list.size();
                if (bundle2 == bundle) {
                    for (int i = 0; i < n2; ++i) {
                        Throwable throwable = this.myFailedOperations.get(list.get(i));
                        Callback<Reply> callback = this.myRealCallbacks.set(n + i, NoOpCallback.NO_OP);
                        if (callback == null) continue;
                        if (throwable == null) {
                            callback.callback(reply);
                            continue;
                        }
                        callback.exception(throwable);
                    }
                    break;
                }
                n += n2;
            }
        }
    }

    private void publishResults() {
        if (this.myFailedOperations.isEmpty()) {
            if (this.myForwardCallback != null) {
                this.myForwardCallback.callback(this.myN);
            }
        } else {
            if (this.mySkippedOperations == null) {
                this.mySkippedOperations = new ArrayList<WriteOperation>();
            }
            for (BatchedWrite.Bundle object : this.myPendingBundles) {
                this.mySkippedOperations.addAll(object.getWrites());
            }
            if (this.myForwardCallback != null) {
                if (this.myBundles.size() == 1 && this.myBundles.get(0).getWrites().size() == 1 && this.myFailedOperations.size() == 1) {
                    this.myForwardCallback.exception(this.myFailedOperations.values().iterator().next());
                } else {
                    this.myForwardCallback.exception(new BatchedWriteException(this.myWrite, this.myN, this.mySkippedOperations, this.myFailedOperations));
                }
            } else {
                List list = Collections.emptyList();
                Map<WriteOperation, Throwable> map = Collections.emptyMap();
                Set set = Collections.newSetFromMap(new IdentityHashMap());
                set.addAll(this.mySkippedOperations);
                Document document = BuilderFactory.start().add("ok", 1).add("n", this.myN).build();
                Reply reply = new Reply(0, 0L, 0, Collections.singletonList(document), false, false, false, false);
                int n = 0;
                for (BatchedWrite.Bundle bundle : this.myBundles) {
                    for (WriteOperation writeOperation : bundle.getWrites()) {
                        Callback<Reply> callback = this.myRealCallbacks.get(n);
                        if (callback != null) {
                            Throwable throwable = this.myFailedOperations.get(writeOperation);
                            if (throwable != null) {
                                callback.exception(new BatchedWriteException(this.myWrite, this.myN, list, Collections.singletonMap(writeOperation, throwable)));
                            } else if (set.contains(writeOperation)) {
                                callback.exception(new BatchedWriteException(this.myWrite, this.myN, Collections.singletonList(writeOperation), map));
                            } else {
                                callback.callback(reply);
                            }
                        }
                        ++n;
                    }
                }
            }
        }
    }

    class BundleCallback
    implements ReplyCallback {
        private final BatchedWrite.Bundle myBundle;

        public BundleCallback(BatchedWrite.Bundle bundle) {
            this.myBundle = bundle;
        }

        @Override
        public void callback(Reply reply) {
            BatchedWriteCallback.this.callback(this.myBundle, reply);
        }

        @Override
        public void exception(Throwable throwable) {
            BatchedWriteCallback.this.exception(this.myBundle, throwable);
        }

        @Override
        public boolean isLightWeight() {
            return false;
        }
    }
}

