/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.callback;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.builder.BatchedWrite;
import com.allanbank.mongodb.builder.BatchedWriteMode;
import com.allanbank.mongodb.builder.write.DeleteOperation;
import com.allanbank.mongodb.builder.write.InsertOperation;
import com.allanbank.mongodb.builder.write.UpdateOperation;
import com.allanbank.mongodb.builder.write.WriteOperation;
import com.allanbank.mongodb.client.AbstractMongoOperations;
import com.allanbank.mongodb.client.callback.ReplyLongCallback;
import com.allanbank.mongodb.error.BatchedWriteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BatchedNativeWriteCallback
extends ReplyLongCallback {
    private final AbstractMongoOperations myCollection;
    private final Map<WriteOperation, Throwable> myFailedOperations;
    private int myFinished;
    private long myN = 0L;
    private final List<WriteOperation> myOperations;
    private final List<WriteOperation> myPendingOperations;
    private final BatchedWrite myWrite;

    public BatchedNativeWriteCallback(Callback<Long> callback, BatchedWrite batchedWrite, AbstractMongoOperations abstractMongoOperations, List<WriteOperation> list) {
        super(callback);
        this.myWrite = batchedWrite;
        this.myCollection = abstractMongoOperations;
        this.myOperations = Collections.unmodifiableList(new ArrayList<WriteOperation>(list));
        this.myPendingOperations = new LinkedList<WriteOperation>(this.myOperations);
        this.myFinished = 0;
        this.myN = 0L;
        this.myFailedOperations = new IdentityHashMap<WriteOperation, Throwable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void send() {
        ArrayList arrayList;
        Durability durability = null;
        BatchedNativeWriteCallback batchedNativeWriteCallback = this;
        synchronized (batchedNativeWriteCallback) {
            void var4_5;
            List<WriteOperation> object = this.myPendingOperations;
            if (BatchedWriteMode.SERIALIZE_AND_STOP.equals((Object)this.myWrite.getMode())) {
                List<WriteOperation> list = this.myPendingOperations.subList(0, 1);
            }
            if ((durability = this.myWrite.getDurability()) == null || durability == Durability.NONE) {
                durability = Durability.ACK;
            }
            arrayList = new ArrayList(var4_5);
            var4_5.clear();
        }
        for (WriteOperation writeOperation : arrayList) {
            switch (writeOperation.getType()) {
                case INSERT: {
                    WriteOperation writeOperation2 = (InsertOperation)writeOperation;
                    this.myCollection.insertAsync(new NativeCallback<Integer>(writeOperation2), true, durability, ((InsertOperation)writeOperation2).getDocument());
                    break;
                }
                case UPDATE: {
                    WriteOperation writeOperation2 = (UpdateOperation)writeOperation;
                    this.myCollection.updateAsync(new NativeCallback<Long>(writeOperation), ((UpdateOperation)writeOperation2).getQuery(), ((UpdateOperation)writeOperation2).getUpdate(), ((UpdateOperation)writeOperation2).isMultiUpdate(), ((UpdateOperation)writeOperation2).isUpsert(), durability);
                    break;
                }
                case DELETE: {
                    WriteOperation writeOperation2 = (DeleteOperation)writeOperation;
                    this.myCollection.deleteAsync(new NativeCallback<Long>(writeOperation), ((DeleteOperation)writeOperation2).getQuery(), ((DeleteOperation)writeOperation2).isSingleDelete(), durability);
                    break;
                }
            }
        }
    }

    protected synchronized void callback(WriteOperation writeOperation, long l) {
        this.myN += l;
        ++this.myFinished;
        if (!this.myPendingOperations.isEmpty()) {
            this.send();
        } else if (this.myFinished == this.myOperations.size()) {
            this.publishResults();
        }
    }

    protected synchronized void exception(WriteOperation writeOperation, Throwable throwable) {
        ++this.myFinished;
        this.myFailedOperations.put(writeOperation, throwable);
        if (this.myWrite.getMode() == BatchedWriteMode.SERIALIZE_AND_STOP) {
            this.publishResults();
        } else if (this.myFinished == this.myOperations.size()) {
            this.publishResults();
        }
    }

    private void publishResults() {
        if (this.myFailedOperations.isEmpty()) {
            this.myForwardCallback.callback(this.myN);
        } else {
            this.myForwardCallback.exception(new BatchedWriteException(this.myWrite, this.myN, this.myPendingOperations, this.myFailedOperations));
        }
    }

    class NativeCallback<T extends Number>
    implements Callback<T> {
        private final WriteOperation myOperation;

        public NativeCallback(WriteOperation writeOperation) {
            this.myOperation = writeOperation;
        }

        @Override
        public void callback(T t) {
            BatchedNativeWriteCallback.this.callback(this.myOperation, ((Number)t).longValue());
        }

        @Override
        public void exception(Throwable throwable) {
            BatchedNativeWriteCallback.this.exception(this.myOperation, throwable);
        }
    }
}

