/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client.callback;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.builder.BatchedWrite;
import com.allanbank.mongodb.builder.write.WriteOperation;
import com.allanbank.mongodb.client.message.Reply;
import com.allanbank.mongodb.error.BatchedWriteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class BatchedInsertCountingCallback
implements Callback<Reply> {
    private int myCount = 0;
    private Map<WriteOperation, Throwable> myErrors;
    private final int myExpectedCount;
    private int myFailureCount = 0;
    private final Callback<Reply> myForwardCallback;
    private BatchedWrite myLastWrite;
    private List<WriteOperation> mySkipped;

    public BatchedInsertCountingCallback(Callback<Reply> callback, int n) {
        this.myForwardCallback = callback;
        this.myExpectedCount = n;
        this.myCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(Reply reply) {
        boolean bl;
        BatchedInsertCountingCallback batchedInsertCountingCallback = this;
        synchronized (batchedInsertCountingCallback) {
            ++this.myCount;
            bl = this.myCount == this.myExpectedCount;
        }
        if (bl) {
            this.publish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(Throwable throwable) {
        boolean bl;
        BatchedInsertCountingCallback batchedInsertCountingCallback = this;
        synchronized (batchedInsertCountingCallback) {
            ++this.myFailureCount;
            ++this.myCount;
            boolean bl2 = bl = this.myCount == this.myExpectedCount;
            if (this.mySkipped == null) {
                this.mySkipped = new ArrayList<WriteOperation>();
                this.myErrors = new IdentityHashMap<WriteOperation, Throwable>();
            }
            if (throwable instanceof BatchedWriteException) {
                BatchedWriteException batchedWriteException = (BatchedWriteException)throwable;
                this.myLastWrite = batchedWriteException.getWrite();
                this.mySkipped.addAll(batchedWriteException.getSkipped());
                this.myErrors.putAll(batchedWriteException.getErrors());
            }
        }
        if (bl) {
            this.publish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish() {
        Reply reply = null;
        BatchedWriteException batchedWriteException = null;
        BatchedInsertCountingCallback batchedInsertCountingCallback = this;
        synchronized (batchedInsertCountingCallback) {
            if (this.myFailureCount == 0) {
                Document document = BuilderFactory.start().add("ok", 1).add("n", this.myExpectedCount).build();
                reply = new Reply(0, 0L, 0, Collections.singletonList(document), false, false, false, false);
            } else {
                batchedWriteException = new BatchedWriteException(this.myLastWrite, (long)(this.myExpectedCount - this.myFailureCount), this.mySkipped, this.myErrors);
            }
        }
        if (reply != null) {
            this.myForwardCallback.callback(reply);
        } else {
            this.myForwardCallback.exception(batchedWriteException);
        }
    }
}

