/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Version;
import java.io.Serializable;

public class VersionRange
implements Serializable {
    private static final long serialVersionUID = 7841643157458023019L;
    private final Version myLowerBounds;
    private final Version myUpperBounds;

    public static VersionRange maximum(Version version) {
        if (version != null) {
            return new VersionRange(Version.VERSION_0, version);
        }
        return null;
    }

    public static VersionRange minimum(Version version) {
        if (version != null) {
            return new VersionRange(version, Version.UNKNOWN);
        }
        return null;
    }

    public static VersionRange range(Version version, Version version2) {
        if (version != null) {
            if (version2 != null) {
                return new VersionRange(version, version2);
            }
            return new VersionRange(version, Version.UNKNOWN);
        }
        if (version2 != null) {
            return new VersionRange(Version.VERSION_0, version2);
        }
        return null;
    }

    private VersionRange(Version version, Version version2) {
        this.myLowerBounds = version;
        this.myUpperBounds = version2;
    }

    public boolean contains(Version version) {
        return this.myLowerBounds.compareTo(version) <= 0 && this.myUpperBounds.compareTo(version) > 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            VersionRange versionRange = (VersionRange)object;
            bl = this.myLowerBounds.equals(versionRange.myLowerBounds) && this.myUpperBounds.equals(versionRange.myUpperBounds);
        }
        return bl;
    }

    public Version getLowerBounds() {
        return this.myLowerBounds;
    }

    public Version getUpperBounds() {
        return this.myUpperBounds;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.myLowerBounds.hashCode();
        n = 31 * n + this.myUpperBounds.hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.myLowerBounds);
        stringBuilder.append(", ");
        stringBuilder.append(this.myUpperBounds);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

