/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.LambdaCallback;
import com.allanbank.mongodb.MongoClient;
import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoCursorControl;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.StreamCallback;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.ClientImpl;
import com.allanbank.mongodb.client.LambdaCallbackAdapter;
import com.allanbank.mongodb.client.MongoDatabaseImpl;
import com.allanbank.mongodb.client.NamedReference;
import com.allanbank.mongodb.client.SerialClientImpl;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MongoClientImpl
implements MongoClient {
    private final Client myClient;
    private final ConcurrentMap<String, Reference<MongoDatabase>> myDatabases;
    private final ReferenceQueue<MongoDatabase> myReferenceQueue = new ReferenceQueue();

    public MongoClientImpl(Client client) {
        this.myClient = client;
        this.myDatabases = new ConcurrentHashMap<String, Reference<MongoDatabase>>();
    }

    public MongoClientImpl(MongoClientConfiguration mongoClientConfiguration) {
        this(new ClientImpl(mongoClientConfiguration));
    }

    @Override
    public MongoClient asSerializedClient() {
        if (this.myClient instanceof SerialClientImpl) {
            return this;
        }
        return new MongoClientImpl(new SerialClientImpl((ClientImpl)this.myClient));
    }

    @Override
    public void close() {
        this.myClient.close();
    }

    public Client getClient() {
        return this.myClient;
    }

    @Override
    public MongoClientConfiguration getConfig() {
        return this.myClient.getConfig();
    }

    @Override
    public MongoDatabase getDatabase(String string) {
        MongoDatabase mongoDatabase;
        Reference reference;
        MongoDatabase mongoDatabase2 = null;
        NamedReference<MongoDatabase> namedReference = (NamedReference<MongoDatabase>)this.myDatabases.get(string);
        if (namedReference != null && (mongoDatabase2 = (MongoDatabase)namedReference.get()) == null) {
            this.myDatabases.remove(string, namedReference);
        }
        if (mongoDatabase2 == null && (reference = (Reference)this.myDatabases.putIfAbsent(string, namedReference = new NamedReference<MongoDatabase>(string, mongoDatabase2 = new MongoDatabaseImpl(this, this.myClient, string), this.myReferenceQueue))) != null && (mongoDatabase = (MongoDatabase)reference.get()) != null) {
            mongoDatabase2 = mongoDatabase;
        }
        while ((reference = this.myReferenceQueue.poll()) != null) {
            if (!(reference instanceof NamedReference)) continue;
            this.myDatabases.remove(((NamedReference)reference).getName(), reference);
        }
        return mongoDatabase2;
    }

    @Override
    public List<String> listDatabaseNames() {
        MongoDatabase mongoDatabase = this.getDatabase("admin");
        Document document = mongoDatabase.runAdminCommand("listDatabases");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StringElement stringElement : document.find(StringElement.class, "databases", ".*", "name")) {
            arrayList.add(stringElement.getValue());
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public List<String> listDatabases() {
        return this.listDatabaseNames();
    }

    @Override
    public MongoIterator<Document> restart(DocumentAssignable documentAssignable) throws IllegalArgumentException {
        return this.myClient.restart(documentAssignable);
    }

    @Override
    public MongoCursorControl restart(LambdaCallback<Document> lambdaCallback, DocumentAssignable documentAssignable) throws IllegalArgumentException {
        return this.restart(new LambdaCallbackAdapter<Document>(lambdaCallback), documentAssignable);
    }

    @Override
    public MongoCursorControl restart(StreamCallback<Document> streamCallback, DocumentAssignable documentAssignable) throws IllegalArgumentException {
        return this.myClient.restart(streamCallback, documentAssignable);
    }
}

