/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.ListenableFuture;
import com.allanbank.mongodb.LockType;
import com.allanbank.mongodb.client.callback.ReplyHandler;
import com.allanbank.mongodb.util.Assertions;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class FutureCallback<V>
implements ListenableFuture<V>,
Callback<V> {
    public static final Log LOG = LogFactory.getLog(FutureCallback.class);
    public static final long SPIN_TIME_NS = TimeUnit.MILLISECONDS.toNanos(1L) / 100L;
    private static final int SPIN_ITERATIONS = 10000;
    private static final long YIELD_TIME_NS = TimeUnit.MILLISECONDS.toNanos(1L) >> 1;
    private final LockType myLockType;
    private AtomicReference<PendingListener> myPendingListeners;
    private final Sync<V> mySync = new Sync();

    public FutureCallback() {
        this(LockType.MUTEX);
    }

    public FutureCallback(LockType lockType) {
        this.myLockType = lockType;
        this.myPendingListeners = new AtomicReference<Object>(null);
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        Assertions.assertNotNull(runnable, "Runnable is null.");
        Assertions.assertNotNull(executor, "Executor is null.");
        if (!this.isDone()) {
            PendingListener pendingListener = this.myPendingListeners.get();
            PendingListener pendingListener2 = new PendingListener(runnable, executor, pendingListener);
            while (!this.myPendingListeners.compareAndSet(pendingListener, pendingListener2)) {
                pendingListener = this.myPendingListeners.get();
                pendingListener2 = new PendingListener(runnable, executor, pendingListener);
            }
            if (this.isDone()) {
                this.execute();
            }
        } else {
            this.execute(executor, runnable);
        }
    }

    @Override
    public void callback(V v) {
        boolean bl = this.mySync.set(v);
        if (bl) {
            this.execute();
        }
    }

    @Override
    public boolean cancel(boolean bl) {
        if (!this.mySync.cancel(bl)) {
            return false;
        }
        this.execute();
        return true;
    }

    @Override
    public void exception(Throwable throwable) {
        Assertions.assertNotNull(throwable, "Cannot set a null exception.");
        boolean bl = this.mySync.setException(throwable);
        if (bl) {
            this.execute();
        }
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        long l;
        if (this.myLockType == LockType.LOW_LATENCY_SPIN) {
            l = 0L;
            long l2 = 1L;
            long l3 = 1L;
            while (l < l3 && !this.isDone()) {
                for (int i = 0; i < 10000 && !this.isDone(); ++i) {
                }
                if (this.isDone()) continue;
                l = System.nanoTime();
                if (l2 == 1L) {
                    l2 = l + SPIN_TIME_NS;
                    l3 = l + YIELD_TIME_NS;
                    Thread.yield();
                    continue;
                }
                if (l2 >= l || l >= l3) continue;
                Thread.yield();
            }
        }
        l = TimeUnit.MILLISECONDS.toNanos(10L);
        while (true) {
            try {
                return this.mySync.get(l);
            }
            catch (TimeoutException timeoutException) {
                ReplyHandler.tryReceive();
                continue;
            }
            break;
        }
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        long l2 = System.nanoTime();
        long l3 = l2 + timeUnit.toNanos(l);
        long l4 = TimeUnit.MILLISECONDS.toNanos(10L);
        while (true) {
            try {
                return this.mySync.get(Math.min(l3 - l2, l4));
            }
            catch (TimeoutException timeoutException) {
                l2 = System.nanoTime();
                if (l2 < l3) {
                    ReplyHandler.tryReceive();
                    continue;
                }
                throw timeoutException;
            }
            break;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.mySync.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.mySync.isDone();
    }

    protected void execute() {
        while (true) {
            PendingListener pendingListener;
            PendingListener pendingListener2;
            if (!this.myPendingListeners.compareAndSet(pendingListener2, pendingListener = (pendingListener2 = this.myPendingListeners.get()) != null ? pendingListener2.myNext : null)) {
                continue;
            }
            if (pendingListener2 != null) {
                this.execute(pendingListener2.myExecutor, pendingListener2.myRunnable);
            }
            if (pendingListener2 == null) break;
        }
    }

    private void execute(Executor executor, Runnable runnable) {
        try {
            executor.execute(runnable);
        }
        catch (RuntimeException runtimeException) {
            LOG.error(runtimeException, "Exception running a FutureListener's runnable {} with executor {}", runnable, executor);
        }
    }

    static final class Sync<V>
    extends AbstractQueuedSynchronizer {
        static final int CANCELED = 4;
        static final int COMPLETED = 2;
        static final int COMPLETING = 1;
        static final int INTERRUPTED = 8;
        static final int RUNNING = 0;
        static final int UNUSED = -1;
        private static final long serialVersionUID = -9189950787072982459L;
        private Throwable myException = null;
        private V myValue = null;

        Sync() {
        }

        @Override
        protected int tryAcquireShared(int n) {
            if (this.isDone()) {
                return 1;
            }
            return -1;
        }

        @Override
        protected boolean tryReleaseShared(int n) {
            this.setState(n);
            return true;
        }

        boolean cancel(boolean bl) {
            return this.complete(null, null, bl ? 8 : 4);
        }

        V get() throws CancellationException, ExecutionException, InterruptedException {
            this.acquireSharedInterruptibly(-1);
            return this.getValue();
        }

        V get(long l) throws TimeoutException, CancellationException, ExecutionException, InterruptedException {
            if (!this.tryAcquireSharedNanos(-1, l)) {
                throw new TimeoutException("Timeout waiting for task.");
            }
            return this.getValue();
        }

        boolean isCancelled() {
            return (this.getState() & 0xC) != 0;
        }

        boolean isDone() {
            return (this.getState() & 0xE) != 0;
        }

        boolean set(V v) {
            return this.complete(v, null, 2);
        }

        boolean setException(Throwable throwable) {
            return this.complete(null, throwable, 2);
        }

        private boolean complete(V v, Throwable throwable, int n) {
            boolean bl = this.compareAndSetState(0, 1);
            if (bl) {
                this.myValue = v;
                this.myException = (n & 0xC) != 0 ? new CancellationException("Future was canceled.") : throwable;
                this.releaseShared(n);
            } else if (this.getState() == 1) {
                this.acquireShared(-1);
            }
            return bl;
        }

        private V getValue() throws CancellationException, ExecutionException {
            int n = this.getState();
            switch (n) {
                case 2: {
                    if (this.myException != null) {
                        throw new ExecutionException(this.myException);
                    }
                    return this.myValue;
                }
                case 4: 
                case 8: {
                    CancellationException cancellationException = new CancellationException("Future was canceled.");
                    cancellationException.initCause(this.myException);
                    throw cancellationException;
                }
            }
            throw new IllegalStateException("Sync in invalid state: " + n);
        }
    }

    static final class PendingListener {
        final Executor myExecutor;
        final PendingListener myNext;
        final Runnable myRunnable;

        PendingListener(Runnable runnable, Executor executor, PendingListener pendingListener) {
            this.myRunnable = runnable;
            this.myExecutor = executor;
            this.myNext = pendingListener;
        }
    }
}

