/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoCursorControl;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.StreamCallback;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.client.AbstractClient;
import com.allanbank.mongodb.client.ClusterStats;
import com.allanbank.mongodb.client.ClusterType;
import com.allanbank.mongodb.client.Message;
import com.allanbank.mongodb.client.MongoIteratorImpl;
import com.allanbank.mongodb.client.callback.CursorStreamingCallback;
import com.allanbank.mongodb.client.connection.Connection;
import com.allanbank.mongodb.client.connection.ConnectionFactory;
import com.allanbank.mongodb.client.connection.ReconnectStrategy;
import com.allanbank.mongodb.client.connection.bootstrap.BootstrapConnectionFactory;
import com.allanbank.mongodb.error.CannotConnectException;
import com.allanbank.mongodb.error.ConnectionLostException;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ClientImpl
extends AbstractClient {
    protected static final Log LOG = LogFactory.getLog(ClientImpl.class);
    private int myActiveReconnects;
    private final MongoClientConfiguration myConfig;
    private final ConnectionFactory myConnectionFactory;
    private final PropertyChangeListener myConnectionListener;
    private final List<Connection> myConnections;
    private final BlockingQueue<Connection> myConnectionsToClose;
    private final AtomicLong myNextConnectionSequence = new AtomicLong(0L);

    protected static ConnectionFactory resolveBootstrap(MongoClientConfiguration mongoClientConfiguration) {
        ConnectionFactory connectionFactory;
        try {
            Class<?> clazz = Class.forName("com.allanbank.mongodb.extensions.bootstrap.ExtensionsBootstrapConnectionFactory");
            Constructor<?> constructor = clazz.getConstructor(MongoClientConfiguration.class);
            connectionFactory = (ConnectionFactory)constructor.newInstance(mongoClientConfiguration);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            connectionFactory = new BootstrapConnectionFactory(mongoClientConfiguration);
        }
        return connectionFactory;
    }

    public ClientImpl(MongoClientConfiguration mongoClientConfiguration) {
        this(mongoClientConfiguration, ClientImpl.resolveBootstrap(mongoClientConfiguration));
    }

    public ClientImpl(MongoClientConfiguration mongoClientConfiguration, ConnectionFactory connectionFactory) {
        this.myConfig = mongoClientConfiguration;
        this.myConnectionFactory = connectionFactory;
        this.myConnections = new CopyOnWriteArrayList<Connection>();
        this.myConnectionsToClose = new LinkedBlockingQueue<Connection>();
        this.myConnectionListener = new ConnectionListener();
        this.myActiveReconnects = 0;
    }

    @Override
    public void close() {
        Object object;
        super.close();
        while (!this.myConnections.isEmpty()) {
            try {
                object = this.myConnections.remove(0);
                this.myConnectionsToClose.add((Connection)object);
                object.shutdown(false);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.getCause();
            }
        }
        object = new ArrayList<Connection>(this.myConnectionsToClose);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            connection.waitForClosed(this.myConfig.getReadTimeout(), TimeUnit.MILLISECONDS);
            if (!connection.isOpen()) continue;
            this.close(connection);
        }
        IOUtils.close(this.myConnectionFactory);
    }

    @Override
    public ClusterStats getClusterStats() {
        return this.myConnectionFactory.getClusterStats();
    }

    @Override
    public ClusterType getClusterType() {
        return this.myConnectionFactory.getClusterType();
    }

    @Override
    public MongoClientConfiguration getConfig() {
        return this.myConfig;
    }

    public int getConnectionCount() {
        return this.myConnections.size();
    }

    @Override
    public Durability getDefaultDurability() {
        return this.myConfig.getDefaultDurability();
    }

    @Override
    public ReadPreference getDefaultReadPreference() {
        return this.myConfig.getDefaultReadPreference();
    }

    public boolean isCursorDocument(Document document) {
        return document.getElements().size() == 5 && document.get(StringElement.class, "ns") != null && document.get(NumericElement.class, "cursor_id") != null && document.get(StringElement.class, "server") != null && document.get(NumericElement.class, "batch_size") != null && document.get(NumericElement.class, "limit") != null;
    }

    @Override
    public MongoIterator<Document> restart(DocumentAssignable documentAssignable) throws IllegalArgumentException {
        Document document = documentAssignable.asDocument();
        if (this.isCursorDocument(document)) {
            MongoIteratorImpl mongoIteratorImpl = new MongoIteratorImpl(document, this);
            mongoIteratorImpl.restart();
            return mongoIteratorImpl;
        }
        throw new IllegalArgumentException("Cannot restart without a well formed cursor document: " + document);
    }

    @Override
    public MongoCursorControl restart(StreamCallback<Document> streamCallback, DocumentAssignable documentAssignable) throws IllegalArgumentException {
        Document document = documentAssignable.asDocument();
        if (this.isCursorDocument(document)) {
            CursorStreamingCallback cursorStreamingCallback = new CursorStreamingCallback(this, document, streamCallback);
            cursorStreamingCallback.restart();
            return cursorStreamingCallback;
        }
        throw new IllegalArgumentException("Cannot restart without a well formed cursor document: " + document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Connection findConnection(Message message, Message message2) throws MongoDbException {
        Closeable closeable;
        int n = Math.max(1, this.myConfig.getMaxConnectionCount());
        if (n < this.myConnections.size()) {
            closeable = this.myConnectionFactory;
            synchronized (closeable) {
                while (n < this.myConnections.size()) {
                    try {
                        Connection connection = this.myConnections.remove(0);
                        this.myConnectionsToClose.add(connection);
                        connection.shutdown(false);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        arrayIndexOutOfBoundsException.getCause();
                    }
                }
            }
        }
        if ((closeable = this.searchConnection(message, message2, true)) == null) {
            throw new CannotConnectException("Could not create a connection to the server.");
        }
        return closeable;
    }

    protected void handleConnectionClosed(Connection connection) {
        if (this.myConnections.contains(connection)) {
            if (connection.isShuttingDown() && this.myConnections.remove(connection)) {
                if (this.myConnections.size() < this.myConfig.getMinConnectionCount()) {
                    LOG.debug("MongoDB Connection closed: {}. Will try to reconnect.", connection);
                    this.reconnect(connection);
                } else {
                    LOG.info("MongoDB Connection closed: {}", connection);
                    connection.removePropertyChangeListener(this.myConnectionListener);
                    connection.raiseErrors(new ConnectionLostException("Connection shutdown."));
                }
            } else {
                LOG.info("Unexpected MongoDB Connection closed: " + connection + ". Will try to reconnect.");
                this.reconnect(connection);
            }
        } else if (this.myConnectionsToClose.remove(connection)) {
            LOG.debug("MongoDB Connection closed: {}", connection);
            connection.removePropertyChangeListener(this.myConnectionListener);
        } else {
            LOG.info("Unknown MongoDB Connection closed: {}", connection);
            connection.removePropertyChangeListener(this.myConnectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconnect(Connection connection) {
        Object object;
        ReconnectStrategy reconnectStrategy = this.myConnectionFactory.getReconnectStrategy();
        try {
            object = this;
            synchronized (object) {
                ++this.myActiveReconnects;
            }
            object = reconnectStrategy.reconnect(connection);
            if (object != null) {
                this.myConnections.add((Connection)object);
                object.addPropertyChangeListener(this.myConnectionListener);
            }
        }
        finally {
            this.myConnections.remove(connection);
            connection.removePropertyChangeListener(this.myConnectionListener);
            object = new ConnectionLostException("Connection lost to MongoDB: " + connection);
            connection.raiseErrors((MongoDbException)object);
            ClientImpl clientImpl = this;
            synchronized (clientImpl) {
                --this.myActiveReconnects;
                this.notifyAll();
            }
        }
    }

    protected Connection searchConnection(Message message, Message message2, boolean bl) throws MongoDbException {
        Connection connection = this.findIdleConnection();
        if (connection == null && (connection = this.tryCreateConnection()) == null && (connection = this.findMostIdleConnection()) == null && bl) {
            connection = this.waitForReconnect(message, message2);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Connection connection) {
        try {
            connection.close();
        }
        catch (IOException iOException) {
            LOG.warn(iOException, "Error closing connection to MongoDB: {}", connection);
        }
        finally {
            this.myConnections.remove(connection);
            this.myConnectionsToClose.remove(connection);
            connection.removePropertyChangeListener(this.myConnectionListener);
        }
    }

    private Connection findIdleConnection() {
        if (!this.myConnections.isEmpty()) {
            long l = this.myNextConnectionSequence.get();
            for (int i = 0; i < Math.min(2, this.myConnections.size()); ++i) {
                long l2 = Math.abs(l + (long)i);
                int n = this.myConnections.size();
                int n2 = (int)(l2 % (long)n);
                try {
                    Connection connection = this.myConnections.get(n2);
                    if (connection.isAvailable() && connection.getPendingCount() == 0) {
                        return connection;
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.getCause();
                }
            }
        }
        return null;
    }

    private Connection findMostIdleConnection() {
        if (!this.myConnections.isEmpty()) {
            long l = this.myConnections.size() <= 1 ? 1L : this.myNextConnectionSequence.incrementAndGet();
            long l2 = l - 1L;
            Connection connection = null;
            Connection connection2 = null;
            while (connection == null || connection2 == null) {
                try {
                    int n = this.myConnections.size();
                    connection = this.myConnections.get((int)(l2 % (long)n));
                    connection2 = this.myConnections.get((int)(l % (long)n));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.getCause();
                }
            }
            if (connection == connection2) {
                if (connection.isAvailable()) {
                    return connection;
                }
            } else if (connection.isAvailable()) {
                if (connection2.isAvailable()) {
                    if (connection.getPendingCount() < connection2.getPendingCount()) {
                        return connection;
                    }
                    return connection2;
                }
            } else if (connection2.isAvailable()) {
                return connection2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection tryCreateConnection() {
        if (this.myConnections.size() < this.myConfig.getMaxConnectionCount()) {
            ConnectionFactory connectionFactory = this.myConnectionFactory;
            synchronized (connectionFactory) {
                int n = Math.max(1, this.myConfig.getMaxConnectionCount());
                if (this.myConnections.size() < n) {
                    try {
                        Connection connection = this.myConnectionFactory.connect();
                        this.myConnections.add(connection);
                        connection.addPropertyChangeListener(this.myConnectionListener);
                        return connection;
                    }
                    catch (IOException iOException) {
                        LOG.warn(iOException, "Could not create a connection.", new Object[0]);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection waitForReconnect(Message message, Message message2) {
        Connection connection = null;
        boolean bl = false;
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            boolean bl2 = bl = 0 < this.myActiveReconnects;
            if (bl) {
                long l;
                long l2 = System.currentTimeMillis();
                long l3 = l = this.myConfig.getReconnectTimeout() <= 0 ? Long.MAX_VALUE : l2 + (long)this.myConfig.getReconnectTimeout();
                while (l2 < l && 0 < this.myActiveReconnects) {
                    try {
                        LOG.debug("Waiting for reconnect to MongoDB.");
                        this.wait(l - l2);
                        l2 = System.currentTimeMillis();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (bl) {
            connection = this.searchConnection(message, message2, false);
        }
        return connection;
    }

    protected class ConnectionListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("open".equals(propertyChangeEvent.getPropertyName()) && Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                ClientImpl.this.handleConnectionClosed((Connection)propertyChangeEvent.getSource());
            }
        }
    }
}

