/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoCursorControl;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.StreamCallback;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.impl.EmptyDocument;
import com.allanbank.mongodb.bson.impl.ImmutableDocument;
import com.allanbank.mongodb.bson.impl.RootDocument;
import com.allanbank.mongodb.builder.Aggregate;
import com.allanbank.mongodb.builder.BatchedWrite;
import com.allanbank.mongodb.builder.Count;
import com.allanbank.mongodb.builder.Distinct;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.FindAndModify;
import com.allanbank.mongodb.builder.GroupBy;
import com.allanbank.mongodb.builder.MapReduce;
import com.allanbank.mongodb.builder.ParallelScan;
import com.allanbank.mongodb.builder.Text;
import com.allanbank.mongodb.builder.TextResult;
import com.allanbank.mongodb.builder.write.WriteOperation;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.ClusterStats;
import com.allanbank.mongodb.client.ClusterType;
import com.allanbank.mongodb.client.VersionRange;
import com.allanbank.mongodb.client.callback.BatchedNativeWriteCallback;
import com.allanbank.mongodb.client.callback.BatchedWriteCallback;
import com.allanbank.mongodb.client.callback.CursorCallback;
import com.allanbank.mongodb.client.callback.CursorStreamingCallback;
import com.allanbank.mongodb.client.callback.LongToIntCallback;
import com.allanbank.mongodb.client.callback.MultipleCursorCallback;
import com.allanbank.mongodb.client.callback.ReplyArrayCallback;
import com.allanbank.mongodb.client.callback.ReplyDocumentCallback;
import com.allanbank.mongodb.client.callback.ReplyIntegerCallback;
import com.allanbank.mongodb.client.callback.ReplyLongCallback;
import com.allanbank.mongodb.client.callback.ReplyResultCallback;
import com.allanbank.mongodb.client.callback.SingleDocumentCallback;
import com.allanbank.mongodb.client.callback.TextCallback;
import com.allanbank.mongodb.client.message.AggregateCommand;
import com.allanbank.mongodb.client.message.Command;
import com.allanbank.mongodb.client.message.Delete;
import com.allanbank.mongodb.client.message.GetLastError;
import com.allanbank.mongodb.client.message.Insert;
import com.allanbank.mongodb.client.message.ParallelScanCommand;
import com.allanbank.mongodb.client.message.Query;
import com.allanbank.mongodb.client.message.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMongoOperations {
    public static final boolean DELETE_SINGLE_DELETE_DEFAULT = false;
    public static final Document EMPTY_INDEX_OPTIONS = EmptyDocument.INSTANCE;
    public static final String ID_FIELD_NAME = "_id";
    public static final boolean INSERT_CONTINUE_ON_ERROR_DEFAULT = false;
    public static final Document UNIQUE_INDEX_OPTIONS = new ImmutableDocument(BuilderFactory.start().add("unique", true));
    public static final boolean UPDATE_MULTIUPDATE_DEFAULT = false;
    public static final boolean UPDATE_UPSERT_DEFAULT = false;
    protected final Client myClient;
    protected final MongoDatabase myDatabase;
    protected final String myName;
    private Durability myDurability;
    private ReadPreference myReadPreference;

    public AbstractMongoOperations(Client client, MongoDatabase mongoDatabase, String string) {
        this.myClient = client;
        this.myDatabase = mongoDatabase;
        this.myName = string;
        this.myDurability = null;
        this.myReadPreference = null;
    }

    public void aggregateAsync(Callback<MongoIterator<Document>> callback, Aggregate aggregate) throws MongoDbException {
        AggregateCommand aggregateCommand = this.toCommand(aggregate, false);
        CursorCallback cursorCallback = new CursorCallback(this.myClient, aggregateCommand, true, callback);
        this.myClient.send(aggregateCommand, cursorCallback);
    }

    public void countAsync(Callback<Long> callback, Count count) throws MongoDbException {
        Version version = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("count", this.getName());
        documentBuilder.addDocument("query", count.getQuery());
        if (count.getMaximumTimeMilliseconds() > 0L) {
            version = Count.MAX_TIMEOUT_VERSION;
            documentBuilder.add("maxTimeMS", count.getMaximumTimeMilliseconds());
        }
        ReadPreference readPreference = this.updateReadPreference(documentBuilder, count.getReadPreference(), true);
        Command command = new Command(this.getDatabaseName(), this.getName(), documentBuilder.build(), count.getQuery(), readPreference, VersionRange.minimum(version));
        this.myClient.send(command, new ReplyLongCallback(callback));
    }

    public void deleteAsync(Callback<Long> callback, DocumentAssignable documentAssignable, boolean bl, Durability durability) throws MongoDbException {
        if (durability != Durability.NONE && this.useWriteCommand() && this.isWriteCommandsSupported(null)) {
            BatchedWrite batchedWrite = BatchedWrite.delete(documentAssignable, bl, durability);
            this.writeAsync(callback, batchedWrite);
        } else {
            Delete delete = new Delete(this.getDatabaseName(), this.myName, documentAssignable.asDocument(), bl);
            if (Durability.NONE.equals(durability)) {
                this.myClient.send(delete, null);
                callback.callback(-1L);
            } else {
                this.myClient.send(delete, this.asGetLastError(durability), new ReplyLongCallback(callback));
            }
        }
    }

    public void distinctAsync(Callback<MongoIterator<Element>> callback, Distinct distinct) throws MongoDbException {
        Version version = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("distinct", this.getName());
        documentBuilder.addString("key", distinct.getKey());
        if (distinct.getQuery() != null) {
            documentBuilder.addDocument("query", distinct.getQuery());
        }
        if (distinct.getMaximumTimeMilliseconds() > 0L) {
            version = Distinct.MAX_TIMEOUT_VERSION;
            documentBuilder.add("maxTimeMS", distinct.getMaximumTimeMilliseconds());
        }
        ReadPreference readPreference = this.updateReadPreference(documentBuilder, distinct.getReadPreference(), true);
        Command command = new Command(this.getDatabaseName(), this.getName(), documentBuilder.build(), readPreference, VersionRange.minimum(version));
        this.myClient.send(command, new ReplyArrayCallback(callback));
    }

    public void explainAsync(Callback<Document> callback, Aggregate aggregate) throws MongoDbException {
        AggregateCommand aggregateCommand = this.toCommand(aggregate, true);
        this.myClient.send(aggregateCommand, new SingleDocumentCallback(callback));
    }

    public void explainAsync(Callback<Document> callback, Find find) throws MongoDbException {
        ReadPreference readPreference = find.getReadPreference();
        if (readPreference == null) {
            readPreference = this.getReadPreference();
        }
        Document document = !readPreference.isLegacy() && this.myClient.getClusterType() == ClusterType.SHARDED ? find.toQueryRequest(true, readPreference) : find.toQueryRequest(true);
        Query query = new Query(this.getDatabaseName(), this.myName, document, find.getProjection(), find.getBatchSize(), find.getLimit(), find.getNumberToSkip(), false, readPreference, false, false, false, find.isPartialOk());
        this.myClient.send(query, new SingleDocumentCallback(callback));
    }

    public void findAndModifyAsync(Callback<Document> callback, FindAndModify findAndModify) throws MongoDbException {
        Version version = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("findAndModify", this.getName());
        documentBuilder.addDocument("query", findAndModify.getQuery());
        if (findAndModify.getUpdate() != null) {
            documentBuilder.addDocument("update", findAndModify.getUpdate());
        }
        if (findAndModify.getSort() != null) {
            documentBuilder.addDocument("sort", findAndModify.getSort());
        }
        if (findAndModify.getFields() != null) {
            documentBuilder.addDocument("fields", findAndModify.getFields());
        }
        if (findAndModify.isRemove()) {
            documentBuilder.addBoolean("remove", true);
        }
        if (findAndModify.isReturnNew()) {
            documentBuilder.addBoolean("new", true);
        }
        if (findAndModify.isUpsert()) {
            documentBuilder.addBoolean("upsert", true);
        }
        if (findAndModify.getMaximumTimeMilliseconds() > 0L) {
            version = FindAndModify.MAX_TIMEOUT_VERSION;
            documentBuilder.add("maxTimeMS", findAndModify.getMaximumTimeMilliseconds());
        }
        Command command = new Command(this.getDatabaseName(), this.getName(), documentBuilder.build(), findAndModify.getQuery(), ReadPreference.PRIMARY, VersionRange.minimum(version));
        this.myClient.send(command, new ReplyDocumentCallback(callback));
    }

    public void findAsync(Callback<MongoIterator<Document>> callback, Find find) throws MongoDbException {
        Query query = this.createQuery(find, find.getLimit(), find.getBatchSize(), find.isTailable(), find.isAwaitData(), find.isImmortalCursor());
        CursorCallback cursorCallback = new CursorCallback(this.myClient, query, false, callback);
        this.myClient.send(query, cursorCallback);
    }

    public void findOneAsync(Callback<Document> callback, Find find) throws MongoDbException {
        Query query = this.createQuery(find, 1, 1, false, false, false);
        this.myClient.send(query, new SingleDocumentCallback(callback));
    }

    public String getDatabaseName() {
        return this.myDatabase.getName();
    }

    public Durability getDurability() {
        Durability durability = this.myDurability;
        if (durability == null) {
            durability = this.myDatabase.getDurability();
        }
        return durability;
    }

    public String getName() {
        return this.myName;
    }

    public ReadPreference getReadPreference() {
        ReadPreference readPreference = this.myReadPreference;
        if (readPreference == null) {
            readPreference = this.myDatabase.getReadPreference();
        }
        return readPreference;
    }

    public void groupByAsync(Callback<MongoIterator<Element>> callback, GroupBy groupBy) throws MongoDbException {
        DocumentAssignable documentAssignable;
        Version version = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        DocumentBuilder documentBuilder2 = documentBuilder.push("group");
        documentBuilder2.addString("ns", this.getName());
        if (!groupBy.getKeys().isEmpty()) {
            documentAssignable = documentBuilder2.push("key");
            for (String string : groupBy.getKeys()) {
                documentAssignable.addBoolean(string, true);
            }
        }
        if (groupBy.getKeyFunction() != null) {
            documentBuilder2.addJavaScript("$keyf", groupBy.getKeyFunction());
        }
        if (groupBy.getInitialValue() != null) {
            documentBuilder2.addDocument("initial", groupBy.getInitialValue());
        }
        if (groupBy.getReduceFunction() != null) {
            documentBuilder2.addJavaScript("$reduce", groupBy.getReduceFunction());
        }
        if (groupBy.getFinalizeFunction() != null) {
            documentBuilder2.addJavaScript("finalize", groupBy.getFinalizeFunction());
        }
        if (groupBy.getQuery() != null) {
            documentBuilder2.addDocument("cond", groupBy.getQuery());
        }
        if (groupBy.getMaximumTimeMilliseconds() > 0L) {
            version = GroupBy.MAX_TIMEOUT_VERSION;
            documentBuilder.add("maxTimeMS", groupBy.getMaximumTimeMilliseconds());
        }
        documentAssignable = this.updateReadPreference(documentBuilder2, groupBy.getReadPreference(), false);
        Command command = new Command(this.getDatabaseName(), this.getName(), documentBuilder.build(), (ReadPreference)documentAssignable, VersionRange.minimum(version));
        this.myClient.send(command, new ReplyArrayCallback("retval", callback));
    }

    public void insertAsync(Callback<Integer> callback, boolean bl, Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.doInsertAsync(callback, bl, durability, null, documentAssignableArray);
    }

    public void mapReduceAsync(Callback<MongoIterator<Document>> callback, MapReduce mapReduce) throws MongoDbException {
        Version version = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("mapreduce", this.getName());
        documentBuilder.addJavaScript("map", mapReduce.getMapFunction());
        documentBuilder.addJavaScript("reduce", mapReduce.getReduceFunction());
        if (mapReduce.getFinalizeFunction() != null) {
            documentBuilder.addJavaScript("finalize", mapReduce.getFinalizeFunction());
        }
        if (mapReduce.getQuery() != null) {
            documentBuilder.addDocument("query", mapReduce.getQuery());
        }
        if (mapReduce.getSort() != null) {
            documentBuilder.addDocument("sort", mapReduce.getSort());
        }
        if (mapReduce.getScope() != null) {
            documentBuilder.addDocument("scope", mapReduce.getScope());
        }
        if (mapReduce.getLimit() != 0) {
            documentBuilder.addInteger("limit", mapReduce.getLimit());
        }
        if (mapReduce.isKeepTemp()) {
            documentBuilder.addBoolean("keeptemp", true);
        }
        if (mapReduce.isJsMode()) {
            documentBuilder.addBoolean("jsMode", true);
        }
        if (mapReduce.isVerbose()) {
            documentBuilder.addBoolean("verbose", true);
        }
        if (mapReduce.getMaximumTimeMilliseconds() > 0L) {
            version = MapReduce.MAX_TIMEOUT_VERSION;
            documentBuilder.add("maxTimeMS", mapReduce.getMaximumTimeMilliseconds());
        }
        DocumentBuilder documentBuilder2 = documentBuilder.push("out");
        switch (mapReduce.getOutputType()) {
            case INLINE: {
                documentBuilder2.addInteger("inline", 1);
                break;
            }
            case REPLACE: {
                documentBuilder2.addString("replace", mapReduce.getOutputName());
                if (mapReduce.getOutputDatabase() == null) break;
                documentBuilder2.addString("db", mapReduce.getOutputDatabase());
                break;
            }
            case MERGE: {
                documentBuilder2.addString("merge", mapReduce.getOutputName());
                if (mapReduce.getOutputDatabase() == null) break;
                documentBuilder2.addString("db", mapReduce.getOutputDatabase());
                break;
            }
            case REDUCE: {
                documentBuilder2.addString("reduce", mapReduce.getOutputName());
                if (mapReduce.getOutputDatabase() == null) break;
                documentBuilder2.addString("db", mapReduce.getOutputDatabase());
            }
        }
        ReadPreference readPreference = this.updateReadPreference(documentBuilder, mapReduce.getReadPreference(), true);
        Command command = new Command(this.getDatabaseName(), this.getName(), documentBuilder.build(), readPreference, VersionRange.minimum(version));
        this.myClient.send(command, new ReplyResultCallback(callback));
    }

    public void parallelScanAsync(Callback<Collection<MongoIterator<Document>>> callback, ParallelScan parallelScan) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("parallelCollectionScan", this.getName());
        documentBuilder.add("numCursors", parallelScan.getRequestedIteratorCount());
        ReadPreference readPreference = this.updateReadPreference(documentBuilder, parallelScan.getReadPreference(), true);
        ParallelScanCommand parallelScanCommand = new ParallelScanCommand(parallelScan, this.getDatabaseName(), this.getName(), documentBuilder.build(), readPreference);
        this.myClient.send(parallelScanCommand, new MultipleCursorCallback(this.myClient, parallelScanCommand, callback));
    }

    public void saveAsync(Callback<Integer> callback, DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        Document document = documentAssignable.asDocument();
        if (document.contains(ID_FIELD_NAME)) {
            this.updateAsync(new LongToIntCallback(callback), BuilderFactory.start().add(document.get(ID_FIELD_NAME)), document, false, true, durability);
        } else {
            this.insertAsync(callback, false, durability, document);
        }
    }

    public void setDurability(Durability durability) {
        this.myDurability = durability;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.myReadPreference = readPreference;
    }

    public MongoCursorControl stream(StreamCallback<Document> streamCallback, Aggregate aggregate) throws MongoDbException {
        AggregateCommand aggregateCommand = this.toCommand(aggregate, false);
        CursorStreamingCallback cursorStreamingCallback = new CursorStreamingCallback(this.myClient, aggregateCommand, true, streamCallback);
        this.myClient.send(aggregateCommand, cursorStreamingCallback);
        return cursorStreamingCallback;
    }

    public MongoCursorControl stream(StreamCallback<Document> streamCallback, Find find) throws MongoDbException {
        Query query = this.createQuery(find, find.getLimit(), find.getBatchSize(), find.isTailable(), find.isAwaitData(), find.isImmortalCursor());
        CursorStreamingCallback cursorStreamingCallback = new CursorStreamingCallback(this.myClient, query, false, streamCallback);
        this.myClient.send(query, cursorStreamingCallback);
        return cursorStreamingCallback;
    }

    @Deprecated
    public void textSearchAsync(Callback<MongoIterator<TextResult>> callback, Text text) throws MongoDbException {
        Version version = Text.REQUIRED_VERSION;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("text", this.getName());
        documentBuilder.addString("search", text.getSearchTerm());
        if (text.getQuery() != null) {
            documentBuilder.add("filter", text.getQuery());
        }
        if (text.getLimit() > 0) {
            documentBuilder.add("limit", text.getLimit());
        }
        if (text.getReturnFields() != null) {
            documentBuilder.add("project", text.getReturnFields());
        }
        if (text.getLanguage() != null) {
            documentBuilder.add("language", text.getLanguage());
        }
        ReadPreference readPreference = this.updateReadPreference(documentBuilder, text.getReadPreference(), true);
        Command command = new Command(this.getDatabaseName(), this.getName(), documentBuilder.build(), readPreference, VersionRange.minimum(version));
        this.myClient.send(command, new ReplyResultCallback(new TextCallback(callback)));
    }

    public void updateAsync(Callback<Long> callback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2, Durability durability) throws MongoDbException {
        ClusterStats clusterStats = this.myClient.getClusterStats();
        if (durability != Durability.NONE && this.useWriteCommand() && this.isWriteCommandsSupported(clusterStats)) {
            BatchedWrite batchedWrite = BatchedWrite.update(documentAssignable, documentAssignable2, bl, bl2, durability);
            this.doWriteAsync(clusterStats, callback, batchedWrite);
        } else {
            Update update = new Update(this.getDatabaseName(), this.myName, documentAssignable.asDocument(), documentAssignable2.asDocument(), bl, bl2);
            if (Durability.NONE == durability) {
                this.myClient.send(update, null);
                callback.callback(-1L);
            } else {
                this.myClient.send(update, this.asGetLastError(durability), new ReplyLongCallback(callback));
            }
        }
    }

    public void writeAsync(Callback<Long> callback, BatchedWrite batchedWrite) throws MongoDbException {
        ClusterStats clusterStats = this.myClient.getClusterStats();
        this.doWriteAsync(clusterStats, callback, batchedWrite);
    }

    protected GetLastError asGetLastError(Durability durability) {
        return new GetLastError(this.getDatabaseName(), durability);
    }

    protected Query createQuery(Find find, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        ReadPreference readPreference = find.getReadPreference();
        if (readPreference == null) {
            readPreference = this.getReadPreference();
        }
        Document document = !readPreference.isLegacy() && this.myClient.getClusterType() == ClusterType.SHARDED ? find.toQueryRequest(false, readPreference) : find.toQueryRequest(false);
        return new Query(this.getDatabaseName(), this.myName, document, find.getProjection(), n2, n, find.getNumberToSkip(), bl, readPreference, bl3, bl2, false, find.isPartialOk());
    }

    protected void doInsertAsync(Callback<Integer> callback, boolean bl, Durability durability, Version version, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        ClusterStats clusterStats = this.myClient.getClusterStats();
        if (durability != Durability.NONE && this.useWriteCommand() && this.isWriteCommandsSupported(clusterStats)) {
            BatchedWrite batchedWrite = BatchedWrite.insert(bl, durability, documentAssignableArray);
            this.doWriteAsync(clusterStats, new LongToIntCallback(callback), batchedWrite);
        } else {
            ArrayList<Document> arrayList = new ArrayList<Document>(documentAssignableArray.length);
            for (DocumentAssignable documentAssignable : documentAssignableArray) {
                Document document = documentAssignable.asDocument();
                if (!document.contains(ID_FIELD_NAME) && document instanceof RootDocument) {
                    ((RootDocument)document).injectId();
                }
                arrayList.add(document);
            }
            Insert insert = new Insert(this.getDatabaseName(), this.myName, arrayList, bl, VersionRange.minimum(version));
            if (Durability.NONE == durability) {
                this.myClient.send(insert, null);
                callback.callback(-1);
            } else {
                this.myClient.send(insert, this.asGetLastError(durability), new ReplyIntegerCallback(callback));
            }
        }
    }

    protected void doWriteAsync(ClusterStats clusterStats, Callback<Long> callback, BatchedWrite batchedWrite) {
        if (this.isWriteCommandsSupported(clusterStats)) {
            List<BatchedWrite.Bundle> list = batchedWrite.toBundles(this.getName(), clusterStats.getSmallestMaxBsonObjectSize(), clusterStats.getSmallestMaxBatchedWriteOperations());
            if (list.isEmpty()) {
                callback.callback(0L);
                return;
            }
            BatchedWriteCallback batchedWriteCallback = new BatchedWriteCallback(this.getDatabaseName(), this.getName(), callback, batchedWrite, this.myClient, list);
            batchedWriteCallback.send();
        } else {
            List<WriteOperation> list = batchedWrite.getWrites();
            if (list.isEmpty()) {
                callback.callback(0L);
                return;
            }
            BatchedNativeWriteCallback batchedNativeWriteCallback = new BatchedNativeWriteCallback(callback, batchedWrite, this, list);
            batchedNativeWriteCallback.send();
        }
    }

    protected boolean isWriteCommandsSupported(ClusterStats clusterStats) {
        ClusterStats clusterStats2 = clusterStats == null ? this.myClient.getClusterStats() : clusterStats;
        VersionRange versionRange = clusterStats2.getServerVersionRange();
        Version version = versionRange.getLowerBounds();
        return BatchedWrite.REQUIRED_VERSION.compareTo(version) <= 0;
    }

    protected AggregateCommand toCommand(Aggregate aggregate, boolean bl) {
        Object object;
        Version version = aggregate.getRequiredVersion();
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("aggregate", this.getName());
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("pipeline");
        for (Element object22 : aggregate.getPipeline()) {
            arrayBuilder.add(object22);
        }
        if (aggregate.isAllowDiskUsage()) {
            documentBuilder.add("allowDiskUsage", true);
        }
        if (aggregate.isUseCursor()) {
            object = documentBuilder.push("cursor");
            if (aggregate.getBatchSize() > 0) {
                object.add("batchSize", aggregate.getBatchSize());
            }
        }
        if (bl) {
            version = Version.later(version, Aggregate.EXPLAIN_VERSION);
            documentBuilder.add("explain", true);
        }
        if (aggregate.getMaximumTimeMilliseconds() > 0L) {
            documentBuilder.add("maxTimeMS", aggregate.getMaximumTimeMilliseconds());
        }
        object = this.updateReadPreference(documentBuilder, aggregate.getReadPreference(), true);
        AggregateCommand aggregateCommand = new AggregateCommand(aggregate, this.getDatabaseName(), this.getName(), documentBuilder.build(), (ReadPreference)object, VersionRange.minimum(version));
        return aggregateCommand;
    }

    protected ReadPreference updateReadPreference(DocumentBuilder documentBuilder, ReadPreference readPreference, boolean bl) {
        ReadPreference readPreference2 = readPreference;
        if (readPreference2 == null) {
            readPreference2 = this.getReadPreference();
        }
        if (!readPreference2.isLegacy() && this.myClient.getClusterType() == ClusterType.SHARDED) {
            if (bl) {
                Document document = documentBuilder.asDocument();
                documentBuilder.reset();
                documentBuilder.add("$query", document);
            }
            documentBuilder.add("$readPreference", readPreference2);
        }
        return readPreference2;
    }

    protected boolean useWriteCommand() {
        return true;
    }
}

