/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.Version;

public class ParallelScan {
    public static final Version REQUIRED_VERSION = Version.parse("2.6.0");
    private final int myBatchSize;
    private final ReadPreference myReadPreference;
    private final int myRequestedIteratorCount;

    public static Builder builder() {
        return new Builder();
    }

    protected ParallelScan(Builder builder) {
        this.myBatchSize = builder.myBatchSize;
        this.myReadPreference = builder.myReadPreference;
        this.myRequestedIteratorCount = builder.myRequestedIteratorCount;
    }

    public int getBatchSize() {
        return this.myBatchSize;
    }

    public ReadPreference getReadPreference() {
        return this.myReadPreference;
    }

    public int getRequestedIteratorCount() {
        return this.myRequestedIteratorCount;
    }

    public static class Builder {
        protected int myBatchSize;
        protected ReadPreference myReadPreference;
        protected int myRequestedIteratorCount;

        public Builder() {
            this.reset();
        }

        public Builder batchSize(int n) {
            return this.setBatchSize(n);
        }

        public ParallelScan build() {
            return new ParallelScan(this);
        }

        public Builder readPreference(ReadPreference readPreference) {
            return this.setReadPreference(readPreference);
        }

        public Builder requestedIteratorCount(int n) {
            return this.setRequestedIteratorCount(n);
        }

        public Builder reset() {
            this.myBatchSize = 0;
            this.myReadPreference = null;
            this.myRequestedIteratorCount = 1;
            return this;
        }

        public Builder setBatchSize(int n) {
            this.myBatchSize = n;
            return this;
        }

        public Builder setReadPreference(ReadPreference readPreference) {
            this.myReadPreference = readPreference;
            return this;
        }

        public Builder setRequestedIteratorCount(int n) {
            this.myRequestedIteratorCount = Math.min(Math.max(n, 1), 10000);
            return this;
        }
    }
}

