/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.Version;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.util.Assertions;
import java.util.concurrent.TimeUnit;

public class Distinct {
    public static final Version MAX_TIMEOUT_VERSION = Find.MAX_TIMEOUT_VERSION;
    private final String myKey;
    private final long myMaximumTimeMilliseconds;
    private final Document myQuery;
    private final ReadPreference myReadPreference;

    public static Builder builder() {
        return new Builder();
    }

    protected Distinct(Builder builder) {
        Assertions.assertNotEmpty(builder.myKey, "The distinct's command key cannot be null or empty.");
        this.myKey = builder.myKey;
        this.myQuery = builder.myQuery;
        this.myReadPreference = builder.myReadPreference;
        this.myMaximumTimeMilliseconds = builder.myMaximumTimeMilliseconds;
    }

    public String getKey() {
        return this.myKey;
    }

    public long getMaximumTimeMilliseconds() {
        return this.myMaximumTimeMilliseconds;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    public ReadPreference getReadPreference() {
        return this.myReadPreference;
    }

    public static class Builder {
        protected String myKey;
        protected long myMaximumTimeMilliseconds;
        protected Document myQuery;
        protected ReadPreference myReadPreference;

        public Builder() {
            this.reset();
        }

        public Distinct build() throws IllegalArgumentException {
            return new Distinct(this);
        }

        public Builder key(String string) {
            return this.setKey(string);
        }

        public Builder maximumTime(long l, TimeUnit timeUnit) {
            return this.setMaximumTimeMilliseconds(timeUnit.toMillis(l));
        }

        public Builder query(DocumentAssignable documentAssignable) {
            return this.setQuery(documentAssignable);
        }

        public Builder readPreference(ReadPreference readPreference) {
            return this.setReadPreference(readPreference);
        }

        public Builder reset() {
            this.myKey = null;
            this.myQuery = null;
            this.myReadPreference = null;
            this.myMaximumTimeMilliseconds = 0L;
            return this;
        }

        public Builder setKey(String string) {
            this.myKey = string;
            return this;
        }

        public Builder setMaximumTimeMilliseconds(long l) {
            this.myMaximumTimeMilliseconds = l;
            return this;
        }

        public Builder setQuery(DocumentAssignable documentAssignable) {
            this.myQuery = documentAssignable.asDocument();
            return this;
        }

        public Builder setReadPreference(ReadPreference readPreference) {
            this.myReadPreference = readPreference;
            return this;
        }
    }
}

