/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.builder.GeoJson;
import com.allanbank.mongodb.util.Assertions;
import java.awt.geom.Point2D;

public class AggregationGeoNear
implements DocumentAssignable {
    private final String myDistanceField;
    private final Double myDistanceMultiplier;
    private final Long myLimit;
    private final Point2D myLocation;
    private final String myLocationField;
    private final Double myMaxDistance;
    private final Document myQuery;
    private final boolean mySpherical;
    private final boolean myUniqueDocs;

    public static Builder builder() {
        return new Builder();
    }

    protected AggregationGeoNear(Builder builder) throws IllegalArgumentException {
        Assertions.assertNotNull(builder.myLocation, "You must specify a location for a geoNear in an aggregation pipeline.");
        Assertions.assertNotEmpty(builder.myDistanceField, "You must specify a distance field locations for a geoNear in an aggregation pipeline.");
        this.myDistanceField = builder.myDistanceField;
        this.myDistanceMultiplier = builder.myDistanceMultiplier;
        this.myLocationField = builder.myLocationField;
        this.myLimit = builder.myLimit;
        this.myLocation = builder.myLocation;
        this.myMaxDistance = builder.myMaxDistance;
        this.myQuery = builder.myQuery;
        this.mySpherical = builder.mySpherical;
        this.myUniqueDocs = builder.myUniqueDocs;
    }

    @Override
    public Document asDocument() {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        GeoJson.addRaw(documentBuilder.pushArray("near"), this.myLocation);
        documentBuilder.add("distanceField", this.myDistanceField);
        documentBuilder.add("spherical", this.mySpherical);
        documentBuilder.add("uniqueDocs", this.myUniqueDocs);
        if (this.myLimit != null) {
            documentBuilder.add("limit", this.myLimit);
        }
        if (this.myMaxDistance != null) {
            documentBuilder.add("maxDistance", this.myMaxDistance);
        }
        if (this.myQuery != null) {
            documentBuilder.add("query", this.myQuery);
        }
        if (this.myDistanceMultiplier != null) {
            documentBuilder.add("distanceMultiplier", this.myDistanceMultiplier);
        }
        if (this.myLocationField != null) {
            documentBuilder.add("includeLocs", this.myLocationField);
        }
        return documentBuilder.build();
    }

    public String getDistanceField() {
        return this.myDistanceField;
    }

    public Double getDistanceMultiplier() {
        return this.myDistanceMultiplier;
    }

    public Long getLimit() {
        return this.myLimit;
    }

    public Point2D getLocation() {
        return this.myLocation;
    }

    public String getLocationField() {
        return this.myLocationField;
    }

    public Double getMaxDistance() {
        return this.myMaxDistance;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    public boolean isSpherical() {
        return this.mySpherical;
    }

    public boolean isUniqueDocs() {
        return this.myUniqueDocs;
    }

    public static class Builder {
        protected String myDistanceField;
        protected Double myDistanceMultiplier;
        protected Long myLimit;
        protected Point2D myLocation;
        protected String myLocationField;
        protected Double myMaxDistance;
        protected Document myQuery;
        protected boolean mySpherical;
        protected boolean myUniqueDocs;

        public Builder() {
            this.reset();
        }

        public AggregationGeoNear build() {
            return new AggregationGeoNear(this);
        }

        public Builder distanceField(String string) {
            return this.setDistanceField(string);
        }

        public Builder distanceMultiplier(double d) {
            return this.setDistanceMultiplier(d);
        }

        public Builder limit(long l) {
            return this.setLimit(l);
        }

        public Builder location(Point2D point2D) {
            return this.setLocation(point2D);
        }

        public Builder locationField(String string) {
            return this.setLocationField(string);
        }

        public Builder maxDistance(double d) {
            return this.setMaxDistance(d);
        }

        public Builder query(DocumentAssignable documentAssignable) {
            return this.setQuery(documentAssignable);
        }

        public Builder reset() {
            this.myDistanceField = null;
            this.myDistanceMultiplier = null;
            this.myLimit = null;
            this.myLocation = null;
            this.myLocationField = null;
            this.myMaxDistance = null;
            this.myQuery = null;
            this.mySpherical = false;
            this.myUniqueDocs = true;
            return this;
        }

        public Builder setDistanceField(String string) {
            this.myDistanceField = string;
            return this;
        }

        public Builder setDistanceMultiplier(double d) {
            this.myDistanceMultiplier = d;
            return this;
        }

        public Builder setLimit(long l) {
            this.myLimit = l;
            return this;
        }

        public Builder setLocation(Point2D point2D) {
            this.myLocation = point2D;
            return this;
        }

        public Builder setLocationField(String string) {
            this.myLocationField = string;
            return this;
        }

        public Builder setMaxDistance(double d) {
            this.myMaxDistance = d;
            return this;
        }

        public Builder setQuery(DocumentAssignable documentAssignable) {
            this.myQuery = documentAssignable != null ? documentAssignable.asDocument() : null;
            return this;
        }

        public Builder setSpherical(boolean bl) {
            this.mySpherical = bl;
            return this;
        }

        public Builder setUniqueDocs(boolean bl) {
            this.myUniqueDocs = bl;
            return this;
        }

        public Builder spherical() {
            return this.setSpherical(true);
        }

        public Builder spherical(boolean bl) {
            return this.setSpherical(bl);
        }

        public Builder uniqueDocs(boolean bl) {
            return this.setUniqueDocs(bl);
        }
    }
}

