/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.io.AbstractStringCache;
import com.allanbank.mongodb.bson.io.SeenString;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class StringEncoderCache
extends AbstractStringCache {
    private Map<String, byte[]> myCache = Collections.emptyMap();

    public StringEncoderCache() {
        this.myMaxCacheLength = 25;
        this.myMaxCachEntries = 24;
    }

    public byte[] find(String string) {
        return this.myCache.get(string);
    }

    @Override
    protected void clear() {
        this.myCache = Collections.emptyMap();
        super.clear();
    }

    @Override
    protected void rebuildCache() {
        SortedMap<Integer, List<SeenString>> sortedMap = this.buildCacheGroups();
        int n = 0;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>((int)Math.ceil((double)Math.min(sortedMap.size(), this.myMaxCachEntries) / 0.75));
        for (List<SeenString> list : sortedMap.values()) {
            for (SeenString seenString : list) {
                if (n < this.myMaxCachEntries) {
                    hashMap.put(seenString.getValue(), seenString.getBytes());
                    ++n;
                    continue;
                }
                this.mySeen.remove(seenString.getValue());
            }
        }
        this.myCache = hashMap;
    }
}

