/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.io.StringDecoderCache;
import java.io.EOFException;
import java.io.StreamCorruptedException;
import java.nio.charset.Charset;

public class StringDecoder {
    static final Charset UTF8 = Charset.forName("UTF-8");
    private final StringBuilder myBuilder = new StringBuilder(64);
    private final StringDecoderCache myCache;

    public StringDecoder() {
        this(new StringDecoderCache());
    }

    public StringDecoder(StringDecoderCache stringDecoderCache) {
        this.myCache = stringDecoderCache;
    }

    public String decode(byte[] byArray, int n, int n2) throws StreamCorruptedException, EOFException {
        String string = this.myCache.find(byArray, n, n2);
        if (string == null) {
            string = this.fastDecode(byArray, n, n2 - 1);
        }
        this.myCache.used(string, byArray, n, n2);
        return string;
    }

    @Deprecated
    public StringDecoderCache getCache() {
        return this.myCache;
    }

    private String fastDecode(byte[] byArray, int n, int n2) {
        int n3;
        boolean bl = true;
        for (int i = 0; bl && i < n2; ++i) {
            n3 = byArray[n + i] & 0xFF;
            if (n3 < 128) {
                this.myBuilder.append((char)n3);
                continue;
            }
            bl = false;
        }
        if (!bl) {
            n3 = this.myBuilder.length();
            String string = new String(byArray, n + n3, n2 - n3, UTF8);
            this.myBuilder.append(string);
        }
        String string = this.myBuilder.toString();
        this.myBuilder.setLength(0);
        return string;
    }
}

