/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.io.BufferingWriteVisitor;
import com.allanbank.mongodb.bson.io.RandomAccessOutputStream;
import com.allanbank.mongodb.bson.io.StringEncoderCache;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferingBsonOutputStream
extends FilterOutputStream {
    private final RandomAccessOutputStream myOutput;
    private final BufferingWriteVisitor myVisitor;

    public BufferingBsonOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.myVisitor = new BufferingWriteVisitor();
        this.myOutput = this.myVisitor.getOutputBuffer();
    }

    public BufferingBsonOutputStream(OutputStream outputStream, StringEncoderCache stringEncoderCache) {
        super(outputStream);
        this.myVisitor = new BufferingWriteVisitor(stringEncoderCache);
        this.myOutput = this.myVisitor.getOutputBuffer();
    }

    public BufferingBsonOutputStream(RandomAccessOutputStream randomAccessOutputStream) {
        super(randomAccessOutputStream);
        this.myVisitor = new BufferingWriteVisitor(randomAccessOutputStream);
        this.myOutput = this.myVisitor.getOutputBuffer();
    }

    public void flushBuffer() throws IOException {
        if (this.out != this.myOutput) {
            this.myVisitor.writeTo(this.out);
            this.myVisitor.reset();
        }
    }

    @Deprecated
    public int getMaxCachedStringEntries() {
        return this.myVisitor.getMaxCachedStringEntries();
    }

    @Deprecated
    public int getMaxCachedStringLength() {
        return this.myVisitor.getMaxCachedStringLength();
    }

    public RandomAccessOutputStream getOutput() {
        return this.myOutput;
    }

    public long getPosition() {
        return this.myOutput.getPosition();
    }

    @Deprecated
    public void setMaxCachedStringEntries(int n) {
        this.myVisitor.setMaxCachedStringEntries(n);
    }

    @Deprecated
    public void setMaxCachedStringLength(int n) {
        this.myVisitor.setMaxCachedStringLength(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public long write(Document document) throws IOException {
        document.accept(this.myVisitor);
        long l = this.myVisitor.getSize();
        this.flushBuffer();
        return l;
    }

    public void writeByte(byte by) {
        this.myOutput.writeByte(by);
    }

    public void writeBytes(byte[] byArray) {
        this.myOutput.writeBytes(byArray);
    }

    public void writeCString(String ... stringArray) {
        this.myOutput.writeCString(stringArray);
    }

    public void writeDocument(Document document) throws IOException {
        document.accept(this.myVisitor);
    }

    public void writeInt(int n) {
        this.myOutput.writeInt(n);
    }

    public void writeIntAt(long l, int n) {
        this.myOutput.writeIntAt(l, n);
    }

    public void writeLong(long l) {
        this.myOutput.writeLong(l);
    }

    public void writeString(String string) {
        this.myOutput.writeString(string);
    }
}

