/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.io.SeenString;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractStringCache {
    public static final int DEFAULT_MAX_CACHE_ENTRIES = 24;
    public static final int DEFAULT_MAX_CACHE_LENGTH = 25;
    protected static final int MAX_MULTIPLIER = 100;
    protected int myMaxCacheLength = 25;
    protected int myMaxCachEntries = 24;
    protected volatile int myMaxCachEntriesMultiplier = 0;
    protected final ConcurrentMap<String, SeenString> mySeen = new ConcurrentHashMap<String, SeenString>(1024);
    protected final AtomicInteger myUseCount = new AtomicInteger(0);

    public int getMaxCacheEntries() {
        return this.myMaxCachEntries;
    }

    public int getMaxCacheLength() {
        return this.myMaxCacheLength;
    }

    public void setMaxCacheEntries(int n) {
        this.myMaxCachEntries = n;
    }

    public void setMaxCacheLength(int n) {
        this.myMaxCacheLength = n;
        if (n <= 0) {
            this.clear();
        }
    }

    public void used(String string, byte[] byArray, int n, int n2) {
        SeenString seenString;
        if (n2 <= 1 || this.myMaxCacheLength < n2) {
            return;
        }
        SeenString seenString2 = (SeenString)this.mySeen.get(string);
        if (seenString2 == null && (seenString = this.mySeen.putIfAbsent(string, seenString2 = new SeenString(byArray, n, n2, string))) != null) {
            seenString2 = seenString;
        }
        seenString2.incrementCount();
        int n3 = this.myUseCount.incrementAndGet();
        while (this.myMaxCachEntries * this.myMaxCachEntriesMultiplier < n3) {
            n3 = this.tryRebuild(n3);
        }
        if (n3 != 0 && n3 % this.myMaxCachEntries == 0) {
            this.trimPending();
        }
    }

    protected SortedMap<Integer, List<SeenString>> buildCacheGroups() {
        this.myMaxCachEntriesMultiplier = Math.min(this.myMaxCachEntriesMultiplier + 1, 100);
        TreeMap<Integer, List<SeenString>> treeMap = new TreeMap<Integer, List<SeenString>>(ReverseIntegerComparator.INSTANCE);
        for (SeenString seenString : this.mySeen.values()) {
            Integer n = seenString.reset();
            LinkedList<SeenString> linkedList = (LinkedList<SeenString>)treeMap.get(n);
            if (linkedList == null) {
                linkedList = new LinkedList<SeenString>();
                treeMap.put(n, linkedList);
            }
            linkedList.add(seenString);
        }
        return treeMap;
    }

    protected void clear() {
        this.mySeen.clear();
        this.myUseCount.set(0);
    }

    protected abstract void rebuildCache();

    private void trimPending() {
        int n = Math.max(1, (int)((double)this.myMaxCachEntries * 0.01));
        int n2 = Math.max(0, this.mySeen.size() - this.myMaxCachEntries);
        Iterator iterator = this.mySeen.values().iterator();
        while (iterator.hasNext() && 0 < n2) {
            SeenString seenString = (SeenString)iterator.next();
            if (seenString.getCount() > n) continue;
            iterator.remove();
            --n2;
        }
    }

    private int tryRebuild(int n) {
        if (this.myUseCount.compareAndSet(n, 0)) {
            this.rebuildCache();
            return 0;
        }
        return this.myUseCount.get();
    }

    public static class ReverseIntegerComparator
    implements Comparator<Integer>,
    Serializable {
        public static final Comparator<Integer> INSTANCE = new ReverseIntegerComparator();
        private static final long serialVersionUID = 7342816815375930353L;

        private ReverseIntegerComparator() {
        }

        @Override
        public int compare(Integer n, Integer n2) {
            int n3 = n.compareTo(n2);
            if (n3 < 0) {
                return 1;
            }
            if (0 < n3) {
                return -1;
            }
            return 0;
        }
    }
}

