/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.impl;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.JsonSerializationVisitor;
import com.allanbank.mongodb.util.PatternUtils;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class AbstractDocument
implements Document {
    public static final List<Element> EMPTY_ELEMENTS = Collections.emptyList();
    protected static final Class<Element> ELEMENT_TYPE = Element.class;
    private static final long serialVersionUID = -425294885378885212L;

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this.getElements());
    }

    @Override
    public Document asDocument() {
        return this;
    }

    @Override
    public boolean contains(String string) {
        return this.getElementMap().containsKey(string);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof Document) {
            Document document = (Document)object;
            bl = this.getElements().equals(document.getElements());
        }
        return bl;
    }

    @Override
    public <E extends Element> List<E> find(Class<E> clazz, String ... stringArray) {
        List list = Collections.emptyList();
        if (0 < stringArray.length) {
            List<Element> list2 = this.getElements();
            String string = stringArray[0];
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            list = new ArrayList();
            try {
                Pattern pattern = PatternUtils.toPattern(string);
                for (Element element : list2) {
                    if (!pattern.matcher(element.getName()).matches()) continue;
                    list.addAll(element.find(clazz, stringArray2));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                for (Element element : list2) {
                    if (!string.equals(element.getName())) continue;
                    list.addAll(element.find(clazz, stringArray2));
                }
            }
        }
        return list;
    }

    @Override
    public List<Element> find(String ... stringArray) {
        return this.find(ELEMENT_TYPE, stringArray);
    }

    @Override
    public <E extends Element> E findFirst(Class<E> clazz, String ... stringArray) {
        E e = null;
        if (0 < stringArray.length) {
            List<Element> list = this.getElements();
            String string = stringArray[0];
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            try {
                Pattern pattern = PatternUtils.toPattern(string);
                Iterator<Element> iterator = list.iterator();
                while (iterator.hasNext() && e == null) {
                    Element element = iterator.next();
                    if (!pattern.matcher(element.getName()).matches()) continue;
                    e = element.findFirst(clazz, stringArray2);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Iterator<Element> iterator = list.iterator();
                while (iterator.hasNext() && e == null) {
                    Element element = iterator.next();
                    if (!string.equals(element.getName())) continue;
                    e = element.findFirst(clazz, stringArray2);
                }
            }
        }
        return e;
    }

    @Override
    public Element findFirst(String ... stringArray) {
        return this.findFirst(ELEMENT_TYPE, stringArray);
    }

    @Override
    public <E extends Element> E get(Class<E> clazz, String string) {
        Element element = this.get(string);
        if (element != null && clazz.isAssignableFrom(element.getClass())) {
            return (E)((Element)clazz.cast(element));
        }
        return null;
    }

    @Override
    public Element get(String string) {
        return this.getElementMap().get(string);
    }

    @Override
    public abstract List<Element> getElements();

    public int hashCode() {
        return this.getElements().hashCode();
    }

    @Override
    public Iterator<Element> iterator() {
        return this.getElements().iterator();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonSerializationVisitor jsonSerializationVisitor = new JsonSerializationVisitor(stringWriter, false);
        this.accept(jsonSerializationVisitor);
        return stringWriter.toString();
    }

    protected abstract Map<String, Element> getElementMap();
}

