/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.io.EndianUtils;
import com.allanbank.mongodb.util.Assertions;
import com.allanbank.mongodb.util.IOUtils;
import java.util.UUID;

public class UuidElement
extends BinaryElement {
    public static final byte LEGACY_UUID_SUBTTYPE = 3;
    public static final int UUID_BINARY_LENGTH = 16;
    public static final byte UUID_SUBTTYPE = 4;
    private static final long serialVersionUID = 6461067538910973839L;
    private final UUID myUuid;

    private static byte[] toBytes(byte by, UUID uUID) {
        Assertions.assertNotNull(uUID, "The UUID value for a UuidElement must not be null.");
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        if (by == 3) {
            l = EndianUtils.swap(l);
            l2 = EndianUtils.swap(l2);
        }
        byte[] byArray = new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL), (byte)(l2 >> 56 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 & 0xFFL)};
        return byArray;
    }

    public UuidElement(String string, byte by, byte[] byArray) {
        super(string, by, byArray);
        this.myUuid = this.toUuid(by, byArray);
    }

    public UuidElement(String string, byte by, byte[] byArray, long l) {
        super(string, by, byArray, l);
        this.myUuid = this.toUuid(by, byArray);
    }

    public UuidElement(String string, byte by, UUID uUID) {
        super(string, by, UuidElement.toBytes(by, uUID));
        this.myUuid = uUID;
    }

    public UuidElement(String string, UUID uUID) {
        super(string, (byte)4, UuidElement.toBytes((byte)4, uUID));
        this.myUuid = uUID;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            UuidElement uuidElement = (UuidElement)object;
            bl = super.equals(object) && this.myUuid.equals(uuidElement.myUuid);
        }
        return bl;
    }

    public UUID getUuid() {
        return this.myUuid;
    }

    @Override
    public UUID getValueAsObject() {
        return this.myUuid;
    }

    @Override
    public String getValueAsString() {
        return this.myUuid.toString();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + this.myUuid.hashCode();
        return n;
    }

    @Override
    public UuidElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new UuidElement(string, this.getSubType(), this.myUuid);
    }

    private UUID toUuid(byte by, byte[] byArray) throws IllegalArgumentException {
        if (byArray.length == 16) {
            int n;
            long l = 0L;
            long l2 = 0L;
            for (n = 0; n < 8; ++n) {
                l <<= 8;
                l += (long)(byArray[n] & 0xFF);
            }
            for (n = 8; n < 16; ++n) {
                l2 <<= 8;
                l2 += (long)(byArray[n] & 0xFF);
            }
            if (by == 3) {
                l = EndianUtils.swap(l);
                l2 = EndianUtils.swap(l2);
            }
            return new UUID(l, l2);
        }
        throw new IllegalArgumentException("The value for a UUID must be 16 bytes long: " + IOUtils.toHex(byArray));
    }
}

