/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.util.Assertions;

public class SymbolElement
extends AbstractElement {
    public static final ElementType TYPE = ElementType.SYMBOL;
    private static final long serialVersionUID = -3181997000292958333L;
    private final String mySymbol;

    private static long computeSize(String string, String string2) {
        long l = 7L;
        l += (long)StringEncoder.utf8Size(string);
        return l += (long)StringEncoder.utf8Size(string2);
    }

    public SymbolElement(String string, String string2) {
        this(string, string2, SymbolElement.computeSize(string, string2));
    }

    public SymbolElement(String string, String string2, long l) {
        super(string, l);
        Assertions.assertNotNull(string2, "Symbol element's symbol cannot be null.");
        this.mySymbol = string2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSymbol(this.getName(), this.getSymbol());
    }

    @Override
    public int compareTo(Element element) {
        int n = super.compareTo(element);
        if (n == 0) {
            ElementType elementType = element.getType();
            n = elementType == ElementType.SYMBOL ? StringElement.utf8Compare(this.mySymbol, ((SymbolElement)element).getSymbol()) : StringElement.utf8Compare(this.mySymbol, ((StringElement)element).getValue());
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            SymbolElement symbolElement = (SymbolElement)object;
            bl = super.equals(object) && this.nullSafeEquals(this.mySymbol, symbolElement.mySymbol);
        }
        return bl;
    }

    public String getSymbol() {
        return this.mySymbol;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public String getValueAsObject() {
        return this.getSymbol();
    }

    @Override
    public String getValueAsString() {
        return this.getSymbol();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.mySymbol != null ? this.mySymbol.hashCode() : 3);
        return n;
    }

    @Override
    public SymbolElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new SymbolElement(string, this.mySymbol);
    }
}

