/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.io.StringEncoder;

public class NullElement
extends AbstractElement {
    public static final ElementType TYPE = ElementType.NULL;
    private static final long serialVersionUID = -4974513577366947524L;

    private static long computeSize(String string) {
        long l = 2L;
        return l += (long)StringEncoder.utf8Size(string);
    }

    public NullElement(String string) {
        this(string, NullElement.computeSize(string));
    }

    public NullElement(String string, long l) {
        super(string, l);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitNull(this.getName());
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public Object getValueAsObject() {
        return null;
    }

    @Override
    public String getValueAsString() {
        return String.valueOf((Object)null);
    }

    @Override
    public NullElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new NullElement(string);
    }
}

