/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.io.StringEncoder;

public class LongElement
extends AbstractElement
implements NumericElement {
    public static final ElementType TYPE = ElementType.LONG;
    private static final long serialVersionUID = -2599658746763036474L;
    private final long myValue;

    private static long computeSize(String string) {
        long l = 10L;
        return l += (long)StringEncoder.utf8Size(string);
    }

    public LongElement(String string, long l) {
        this(string, l, LongElement.computeSize(string));
    }

    public LongElement(String string, long l, long l2) {
        super(string, l2);
        this.myValue = l;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLong(this.getName(), this.getValue());
    }

    @Override
    public int compareTo(Element element) {
        int n = super.compareTo(element);
        if (n == 0) {
            NumericElement numericElement = (NumericElement)element;
            ElementType elementType = numericElement.getType();
            n = elementType == ElementType.DOUBLE ? Double.compare(this.getDoubleValue(), numericElement.getDoubleValue()) : LongElement.compare(this.getLongValue(), numericElement.getLongValue());
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            LongElement longElement = (LongElement)object;
            bl = super.equals(object) && this.myValue == longElement.myValue;
        }
        return bl;
    }

    @Override
    public double getDoubleValue() {
        return this.myValue;
    }

    @Override
    public int getIntValue() {
        return (int)this.myValue;
    }

    @Override
    public long getLongValue() {
        return this.myValue;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    public long getValue() {
        return this.myValue;
    }

    @Override
    public Long getValueAsObject() {
        return this.myValue;
    }

    @Override
    public String getValueAsString() {
        return Long.toString(this.myValue);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (int)(this.myValue & 0xFFFFFFFFFFFFFFFFL);
        n = 31 * n + (int)(this.myValue >> 32 & 0xFFFFFFFFFFFFFFFFL);
        return n;
    }

    @Override
    public LongElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new LongElement(string, this.myValue);
    }
}

