/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.JavaScriptElement;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.util.Assertions;
import java.util.Iterator;

public class JavaScriptWithScopeElement
extends JavaScriptElement {
    public static final ElementType TYPE = ElementType.JAVA_SCRIPT_WITH_SCOPE;
    private static final long serialVersionUID = -5697976862389984453L;
    private final Document myScope;

    private static long computeSize(String string, String string2, Document document) {
        long l = 15L;
        l += (long)StringEncoder.utf8Size(string);
        l += (long)StringEncoder.utf8Size(string2);
        if (document != null) {
            l += document.size();
        }
        return l;
    }

    public JavaScriptWithScopeElement(String string, String string2, Document document) {
        this(string, string2, document, JavaScriptWithScopeElement.computeSize(string, string2, document));
        Assertions.assertNotNull(document, "JavaScript element's scope cannot be null.");
    }

    public JavaScriptWithScopeElement(String string, String string2, Document document, long l) {
        super(string, string2, l);
        Assertions.assertNotNull(document, "JavaScript element's scope cannot be null.");
        this.myScope = document;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitJavaScript(this.getName(), this.getJavaScript(), this.getScope());
    }

    @Override
    public int compareTo(Element element) {
        int n = super.compareTo(element);
        if (n == 0) {
            JavaScriptWithScopeElement javaScriptWithScopeElement = (JavaScriptWithScopeElement)element;
            Iterator iterator = this.myScope.iterator();
            Iterator iterator2 = javaScriptWithScopeElement.myScope.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                n = ((Element)iterator.next()).compareTo((Element)iterator2.next());
                if (n == 0) continue;
                return n;
            }
            if (iterator.hasNext()) {
                return 1;
            }
            if (iterator2.hasNext()) {
                return -1;
            }
            return 0;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            JavaScriptWithScopeElement javaScriptWithScopeElement = (JavaScriptWithScopeElement)object;
            bl = super.equals(object) && this.nullSafeEquals(this.myScope, javaScriptWithScopeElement.myScope);
        }
        return bl;
    }

    public Document getScope() {
        return this.myScope;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public Document getValueAsObject() {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("$code", this.getJavaScript());
        documentBuilder.add("$scope", this.myScope);
        return documentBuilder.build();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myScope != null ? this.myScope.hashCode() : 3);
        return n;
    }

    @Override
    public JavaScriptWithScopeElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new JavaScriptWithScopeElement(string, this.getJavaScript(), this.myScope);
    }
}

