/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.io.StringEncoder;

public class IntegerElement
extends AbstractElement
implements NumericElement {
    public static final ElementType TYPE = ElementType.INTEGER;
    private static final long serialVersionUID = 3738845320555958508L;
    private final int myValue;

    private static long computeSize(String string) {
        long l = 6L;
        return l += (long)StringEncoder.utf8Size(string);
    }

    public IntegerElement(String string, int n) {
        this(string, n, IntegerElement.computeSize(string));
    }

    public IntegerElement(String string, int n, long l) {
        super(string, l);
        this.myValue = n;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInteger(this.getName(), this.getValue());
    }

    @Override
    public int compareTo(Element element) {
        int n = super.compareTo(element);
        if (n == 0) {
            NumericElement numericElement = (NumericElement)element;
            ElementType elementType = numericElement.getType();
            n = IntegerElement.compare(this.getIntValue(), numericElement.getIntValue());
            n = elementType == ElementType.INTEGER ? IntegerElement.compare(this.getIntValue(), numericElement.getIntValue()) : (elementType == ElementType.LONG ? IntegerElement.compare(this.getLongValue(), numericElement.getLongValue()) : Double.compare(this.getDoubleValue(), numericElement.getDoubleValue()));
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            IntegerElement integerElement = (IntegerElement)object;
            bl = super.equals(object) && this.myValue == integerElement.myValue;
        }
        return bl;
    }

    @Override
    public double getDoubleValue() {
        return this.myValue;
    }

    @Override
    public int getIntValue() {
        return this.myValue;
    }

    @Override
    public long getLongValue() {
        return this.myValue;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    public int getValue() {
        return this.myValue;
    }

    @Override
    public Integer getValueAsObject() {
        return this.myValue;
    }

    @Override
    public String getValueAsString() {
        return Integer.toString(this.myValue);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + this.myValue;
        return n;
    }

    @Override
    public IntegerElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new IntegerElement(string, this.myValue);
    }
}

