/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.StringEncoder;
import com.allanbank.mongodb.util.Assertions;
import java.io.IOException;
import java.util.Arrays;

public class BinaryElement
extends AbstractElement {
    public static final byte DEFAULT_SUB_TYPE = 0;
    public static final ElementType TYPE = ElementType.BINARY;
    private static final long serialVersionUID = 5864918707454038001L;
    private final byte mySubType;
    private final byte[] myValue;

    private static long computeSize(String string, byte by, int n) {
        long l = 7L;
        l += (long)StringEncoder.utf8Size(string);
        l += (long)n;
        if (by == 2) {
            l += 4L;
        }
        return l;
    }

    public BinaryElement(String string, byte by, BsonInputStream bsonInputStream, int n) throws IOException {
        this(string, by, bsonInputStream, n, BinaryElement.computeSize(string, by, n));
    }

    public BinaryElement(String string, byte by, BsonInputStream bsonInputStream, int n, long l) throws IOException {
        super(string, l);
        this.mySubType = by;
        this.myValue = new byte[n];
        bsonInputStream.readFully(this.myValue);
    }

    public BinaryElement(String string, byte by, byte[] byArray) {
        this(string, by, byArray, BinaryElement.computeSize(string, by, byArray == null ? 0 : byArray.length));
    }

    public BinaryElement(String string, byte by, byte[] byArray, long l) {
        super(string, l);
        Assertions.assertNotNull(byArray, "Binary element's value cannot be null.  Add a null element instead.");
        this.mySubType = by;
        this.myValue = (byte[])byArray.clone();
    }

    public BinaryElement(String string, byte[] byArray) {
        this(string, 0, byArray);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBinary(this.getName(), this.getSubType(), this.getValue());
    }

    @Override
    public int compareTo(Element element) {
        int n = super.compareTo(element);
        if (n == 0) {
            BinaryElement binaryElement = (BinaryElement)element;
            n = this.mySubType - binaryElement.mySubType;
            if (n == 0) {
                int n2 = Math.min(this.myValue.length, binaryElement.myValue.length);
                for (int i = 0; i < n2; ++i) {
                    n = this.myValue[i] - binaryElement.myValue[i];
                    if (n == 0) continue;
                    return n;
                }
                n = this.myValue.length - binaryElement.myValue.length;
            }
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            BinaryElement binaryElement = (BinaryElement)object;
            bl = super.equals(object) && this.mySubType == binaryElement.mySubType && Arrays.equals(this.myValue, binaryElement.myValue);
        }
        return bl;
    }

    public final byte get(int n) {
        return this.myValue[n];
    }

    public byte getSubType() {
        return this.mySubType;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    public byte[] getValue() {
        return (byte[])this.myValue.clone();
    }

    @Override
    public Object getValueAsObject() {
        return this.getValue();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + this.mySubType;
        n = 31 * n + Arrays.hashCode(this.myValue);
        return n;
    }

    public final int length() {
        return this.myValue.length;
    }

    @Override
    public BinaryElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new BinaryElement(string, this.mySubType, this.myValue);
    }
}

