/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Version
implements Serializable,
Comparable<Version> {
    public static final Version UNKNOWN;
    public static final Version VERSION;
    public static final Version VERSION_0;
    public static final Version VERSION_2_0;
    public static final Version VERSION_2_2;
    public static final Version VERSION_2_4;
    public static final Version VERSION_2_6;
    protected static final Version VERSION_2_5_2;
    protected static final Version VERSION_2_5_4;
    private static final Log LOG;
    private static final long serialVersionUID = 4726973040107711788L;
    private final String mySuffix;
    private final int[] myVersion;

    public static Version earlier(Version version, Version version2) {
        if (version == null || version2 != null && version.compareTo(version2) > 0) {
            return version2;
        }
        return version;
    }

    public static Version forWireVersion(int n) {
        Version version = null;
        if (n >= 2) {
            version = VERSION_2_5_4;
        } else if (n == 1) {
            version = VERSION_2_5_2;
        } else if (n == 0) {
            version = VERSION_2_4;
        }
        return version;
    }

    public static Version later(Version version, Version version2) {
        if (version == null || version2 != null && version.compareTo(version2) < 0) {
            return version2;
        }
        return version;
    }

    public static Version parse(List<NumericElement> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = list.get(i).getIntValue();
        }
        return new Version(nArray, null);
    }

    public static Version parse(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string3 = stringArray[i];
            if (i == stringArray.length - 1 && (n = string3.indexOf(45)) >= 0) {
                string2 = string3.substring(n + 1);
                string3 = string3.substring(0, n);
            }
            try {
                nArray[i] = Integer.parseInt(string3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.debug("Could not parse version string token ('{}') from version '{}'.", string3, string);
            }
        }
        return new Version(nArray, string2);
    }

    private Version(int[] nArray, String string) {
        this.myVersion = (int[])nArray.clone();
        this.mySuffix = string != null ? string : "";
    }

    @Override
    public int compareTo(Version version) {
        int n = 0;
        if (UNKNOWN.equals(this)) {
            n = UNKNOWN.equals(version) ? 0 : 1;
        } else if (UNKNOWN.equals(version)) {
            n = -1;
        }
        int n2 = Math.min(this.myVersion.length, version.myVersion.length);
        for (int i = 0; n == 0 && i < n2; ++i) {
            n = this.compare(this.myVersion[i], version.myVersion[i]);
        }
        if (n == 0 && (n = this.compare(this.myVersion.length, version.myVersion.length)) == 0) {
            n = this.mySuffix.compareTo(version.mySuffix);
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Version version = (Version)object;
            bl = this.mySuffix.equals(version.mySuffix) && Arrays.equals(this.myVersion, version.myVersion);
        }
        return bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.mySuffix.hashCode();
        n = 31 * n + Arrays.hashCode(this.myVersion);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.myVersion.length; ++i) {
            if (i != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(String.valueOf(this.myVersion[i]));
        }
        if (!this.mySuffix.isEmpty()) {
            if (this.myVersion.length > 0) {
                stringBuilder.append('-');
            }
            stringBuilder.append(this.mySuffix);
        }
        return stringBuilder.toString();
    }

    protected int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        VERSION_0 = Version.parse("0");
        VERSION_2_0 = Version.parse("2.0");
        VERSION_2_2 = Version.parse("2.2");
        VERSION_2_4 = Version.parse("2.4");
        VERSION_2_6 = Version.parse("2.6");
        VERSION_2_5_2 = Version.parse("2.5.2");
        VERSION_2_5_4 = Version.parse("2.5.4");
        LOG = LogFactory.getLog(Version.class);
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = Version.class.getResourceAsStream("/META-INF/maven/com.allanbank/mongodb-async-driver/pom.properties");
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            LOG.info("Could not read the version information for the driver.");
        }
        finally {
            IOUtils.close(inputStream);
        }
        VERSION = Version.parse(properties.getProperty("version", "0-DEVELOPMENT"));
        UNKNOWN = new Version(new int[0], "UNKNOWN");
    }
}

