/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.Credential;
import com.allanbank.mongodb.MongoDbUri;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.beans.PropertyEditorSupport;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CredentialEditor
extends PropertyEditorSupport {
    public static final Set<String> MONGODB_URI_FIELDS;
    protected static final Log LOG;

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (MongoDbUri.isUri(string)) {
            Object object;
            Credential.Builder builder = null;
            MongoDbUri mongoDbUri = new MongoDbUri(string);
            if (mongoDbUri.getUserName() != null) {
                builder = Credential.builder().userName(mongoDbUri.getUserName()).password(mongoDbUri.getPassword().toCharArray());
                object = mongoDbUri.getDatabase();
                if (!((String)object).isEmpty()) {
                    builder.database((String)object);
                }
            }
            if ((object = this.fromUriParameters(builder, mongoDbUri.getParsedOptions())) != null) {
                this.setValue(object);
            }
        } else {
            throw new IllegalArgumentException("Could not determine the credentials for '" + string + "'.");
        }
    }

    private Credential fromUriParameters(Credential.Builder builder, Map<String, String> map) {
        String string;
        String string2;
        String string3 = map.remove("gssapiservicename");
        if (string3 != null) {
            if (builder != null) {
                builder.kerberos().addOption("kerberos.service.name", string3);
            } else {
                LOG.info("Must supply a user name to set a gssapiServiceName: '{}'.", string3);
            }
        }
        if ((string2 = map.remove("authsource")) != null) {
            if (builder != null) {
                builder.setDatabase(string2);
            } else {
                LOG.info("Must supply a user name to set a authSource: '{}'.", string2);
            }
        }
        if ((string = map.remove("authmechanism")) != null) {
            if (builder != null) {
                if ("MONGODB-CR".equalsIgnoreCase(string)) {
                    builder.mongodbCR();
                } else if ("MONGODB-X509".equalsIgnoreCase(string)) {
                    builder.x509();
                } else if ("GSSAPI".equalsIgnoreCase(string)) {
                    builder.kerberos();
                } else if ("PLAIN".equalsIgnoreCase(string)) {
                    builder.plainSasl();
                } else {
                    LOG.warn("Unknown authMechanism: '{}'. Not authenticating.", string);
                }
            } else {
                LOG.info("Must supply a user name and password to set a authMechanism: '{}'.", string);
            }
        }
        if (builder != null) {
            return builder.build();
        }
        return null;
    }

    static {
        LOG = LogFactory.getLog(CredentialEditor.class);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("gssapiservicename");
        hashSet.add("authsource");
        hashSet.add("authmechanism");
        MONGODB_URI_FIELDS = Collections.unmodifiableSet(hashSet);
    }
}

