/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.client.connection.auth.Authenticator;
import com.allanbank.mongodb.client.connection.auth.MongoDbAuthenticator;
import com.allanbank.mongodb.error.MongoDbAuthenticationException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Credential
implements Serializable {
    public static final String ADMIN_DB = "admin";
    public static final String KERBEROS;
    public static final String MONGODB_CR;
    public static final char[] NO_PASSWORD;
    public static final String PLAIN_SASL;
    public static final String X509;
    private static final long serialVersionUID = -6251469373336569336L;
    private final String myAuthenticationType;
    private transient Authenticator myAuthenticator;
    private final String myDatabase;
    private final File myFile;
    private final Map<String, String> myOptions;
    private final char[] myPassword;
    private final String myUserName;

    public static Builder builder() {
        return new Builder();
    }

    public Credential(Builder builder) {
        this.myUserName = builder.myUserName;
        this.myDatabase = builder.myDatabase;
        this.myFile = builder.myFile;
        this.myAuthenticationType = builder.myAuthenticationType;
        this.myAuthenticator = builder.myAuthenticator;
        this.myPassword = (char[])builder.myPassword.clone();
        this.myOptions = Collections.unmodifiableMap(new HashMap<String, String>(builder.myOptions));
    }

    public Authenticator authenticator() throws MongoDbAuthenticationException {
        if (this.myAuthenticator == null) {
            try {
                this.loadAuthenticator();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MongoDbAuthenticationException(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new MongoDbAuthenticationException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MongoDbAuthenticationException(illegalAccessException);
            }
        }
        return this.myAuthenticator.clone();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Credential credential = (Credential)object;
            bl = this.nullSafeEquals(this.myAuthenticationType, credential.myAuthenticationType) && this.nullSafeEquals(this.myDatabase, credential.myDatabase) && this.nullSafeEquals(this.myUserName, credential.myUserName) && this.nullSafeEquals(this.myFile, credential.myFile) && this.nullSafeEquals(this.myOptions, credential.myOptions) && Arrays.equals(this.myPassword, credential.myPassword);
        }
        return bl;
    }

    public String getAuthenticationType() {
        return this.myAuthenticationType;
    }

    public Authenticator getAuthenticator() {
        return this.myAuthenticator;
    }

    public String getDatabase() {
        return this.myDatabase;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean getOption(String string, boolean bl) {
        String string2 = this.myOptions.get(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public int getOption(String string, int n) {
        String string2 = this.myOptions.get(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return n;
    }

    public String getOption(String string, String string2) {
        String string3 = this.myOptions.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public char[] getPassword() {
        return (char[])this.myPassword.clone();
    }

    public String getUserName() {
        return this.myUserName;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.myAuthenticationType == null ? 0 : this.myAuthenticationType.hashCode());
        n = 31 * n + (this.myDatabase == null ? 0 : this.myDatabase.hashCode());
        n = 31 * n + this.myOptions.hashCode();
        n = 31 * n + Arrays.hashCode(this.myPassword);
        n = 31 * n + (this.myUserName == null ? 0 : this.myUserName.hashCode());
        n = 31 * n + (this.myFile == null ? 0 : this.myFile.hashCode());
        return n;
    }

    public boolean hasPassword() {
        return this.myPassword.length > 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ username : '");
        stringBuilder.append(this.myUserName);
        stringBuilder.append("', database : '");
        stringBuilder.append(this.myDatabase);
        if (this.myFile != null) {
            stringBuilder.append("', file : '");
            stringBuilder.append(this.myFile.getName());
        }
        stringBuilder.append("', password : '<redacted>', type: '");
        if (KERBEROS.equals(this.myAuthenticationType)) {
            stringBuilder.append("KERBEROS");
        } else if (PLAIN_SASL.equals(this.myAuthenticationType)) {
            stringBuilder.append("PLAIN SASL");
        } else if (X509.equals(this.myAuthenticationType)) {
            stringBuilder.append("x.509");
        } else if (MONGODB_CR.equals(this.myAuthenticationType)) {
            stringBuilder.append("MONGODB-CR");
        } else if (this.myAuthenticationType != null) {
            stringBuilder.append(this.myAuthenticationType);
        }
        for (Map.Entry<String, String> entry : this.myOptions.entrySet()) {
            stringBuilder.append("', '");
            stringBuilder.append(entry.getKey());
            stringBuilder.append("': '");
            stringBuilder.append(entry.getValue());
        }
        stringBuilder.append("' }");
        return stringBuilder.toString();
    }

    void loadAuthenticator() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.myAuthenticator == null) {
            this.myAuthenticator = (Authenticator)Class.forName(this.getAuthenticationType()).newInstance();
        }
    }

    private boolean nullSafeEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.myAuthenticator = null;
    }

    static {
        NO_PASSWORD = new char[0];
        KERBEROS = "com.allanbank.mongodb.extensions.authentication.KerberosAuthenticator";
        MONGODB_CR = MongoDbAuthenticator.class.getName();
        PLAIN_SASL = "com.allanbank.mongodb.extensions.authentication.PlainSaslAuthenticator";
        X509 = "com.allanbank.mongodb.extensions.authentication.X509Authenticator";
    }

    public static class Builder {
        protected String myAuthenticationType;
        protected Authenticator myAuthenticator;
        protected String myDatabase;
        protected File myFile;
        protected final Map<String, String> myOptions = new HashMap<String, String>();
        protected char[] myPassword;
        protected String myUserName;

        public Builder() {
            this.reset();
        }

        public Builder addOption(String string, boolean bl) {
            this.myOptions.put(string, String.valueOf(bl));
            return this;
        }

        public Builder addOption(String string, int n) {
            this.myOptions.put(string, String.valueOf(n));
            return this;
        }

        public Builder addOption(String string, String string2) {
            this.myOptions.put(string, string2);
            return this;
        }

        public Builder authenticationType(String string) {
            return this.setAuthenticationType(string);
        }

        public Builder authenticator(Authenticator authenticator) {
            return this.setAuthenticator(authenticator);
        }

        public Credential build() {
            return new Credential(this);
        }

        public Builder database(String string) {
            return this.setDatabase(string);
        }

        public Builder file(File file) {
            return this.setFile(file);
        }

        public Builder kerberos() {
            return this.setAuthenticationType(KERBEROS);
        }

        public Builder ldap() {
            return this.setAuthenticationType(PLAIN_SASL);
        }

        public Builder mongodbCR() {
            return this.setAuthenticationType(MONGODB_CR);
        }

        public Builder pam() {
            return this.setAuthenticationType(PLAIN_SASL);
        }

        public Builder password(char[] cArray) {
            return this.setPassword(cArray);
        }

        public Builder plainSasl() {
            return this.setAuthenticationType(PLAIN_SASL);
        }

        public Builder reset() {
            if (this.myPassword != null) {
                Arrays.fill(this.myPassword, '\u0000');
            }
            this.myAuthenticationType = MONGODB_CR;
            this.myAuthenticator = null;
            this.myDatabase = Credential.ADMIN_DB;
            this.myFile = null;
            this.myPassword = NO_PASSWORD;
            this.myUserName = null;
            this.myOptions.clear();
            return this;
        }

        public Builder setAuthenticationType(String string) {
            this.myAuthenticationType = string;
            return this;
        }

        public Builder setAuthenticator(Authenticator authenticator) {
            this.myAuthenticator = authenticator;
            return this;
        }

        public Builder setDatabase(String string) {
            this.myDatabase = string == null ? Credential.ADMIN_DB : string;
            return this;
        }

        public Builder setFile(File file) {
            this.myFile = file;
            return this;
        }

        public Builder setPassword(char[] cArray) {
            Arrays.fill(this.myPassword, '\u0000');
            this.myPassword = cArray == null ? NO_PASSWORD : (char[])cArray.clone();
            return this;
        }

        public Builder setUserName(String string) {
            this.myUserName = string;
            return this;
        }

        public Builder userName(String string) {
            return this.setUserName(string);
        }

        public Builder x509() {
            return this.setAuthenticationType(X509);
        }

        public Builder x509(X509Certificate x509Certificate) {
            return this.userName(x509Certificate.getSubjectX500Principal().toString()).x509();
        }
    }
}

