/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.CancelDelegationTokenServlet;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryServlet;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FileChecksumServlets;
import org.apache.hadoop.hdfs.server.namenode.FileDataServlet;
import org.apache.hadoop.hdfs.server.namenode.FsckServlet;
import org.apache.hadoop.hdfs.server.namenode.GetDelegationTokenServlet;
import org.apache.hadoop.hdfs.server.namenode.GetImageServlet;
import org.apache.hadoop.hdfs.server.namenode.ListPathsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.RenewDelegationTokenServlet;
import org.apache.hadoop.hdfs.server.namenode.StartupProgressServlet;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.AuthFilter;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.mortbay.jetty.servlet.Context;

@InterfaceAudience.Private
public class NameNodeHttpServer {
    private HttpServer httpServer;
    private final Configuration conf;
    private final NameNode nn;
    private InetSocketAddress httpAddress;
    private InetSocketAddress bindAddress;
    public static final String NAMENODE_ADDRESS_ATTRIBUTE_KEY = "name.node.address";
    public static final String FSIMAGE_ATTRIBUTE_KEY = "name.system.image";
    protected static final String NAMENODE_ATTRIBUTE_KEY = "name.node";
    public static final String STARTUP_PROGRESS_ATTRIBUTE_KEY = "startup.progress";

    public NameNodeHttpServer(Configuration conf, NameNode nn, InetSocketAddress bindAddress) {
        this.conf = conf;
        this.nn = nn;
        this.bindAddress = bindAddress;
    }

    public void start() throws IOException {
        int infoPort;
        String infoHost = this.bindAddress.getHostName();
        this.httpServer = new HttpServer("hdfs", infoHost, infoPort, (infoPort = this.bindAddress.getPort()) == 0, this.conf, new AccessControlList(this.conf.get("dfs.cluster.administrators", " "))){
            {
                if (UserGroupInformation.isSecurityEnabled()) {
                    this.initSpnego(NameNodeHttpServer.this.conf, "dfs.namenode.kerberos.internal.spnego.principal", DFSUtil.getSpnegoKeytabKey(NameNodeHttpServer.this.conf, "dfs.namenode.keytab.file"));
                }
                if (WebHdfsFileSystem.isEnabled(NameNodeHttpServer.this.conf, LOG)) {
                    String name = "SPNEGO";
                    String classname = AuthFilter.class.getName();
                    String pathSpec = "/webhdfs/v1/*";
                    Map<String, String> params = this.getAuthFilterParams(NameNodeHttpServer.this.conf);
                    this.defineFilter((Context)this.webAppContext, "SPNEGO", classname, params, new String[]{"/webhdfs/v1/*"});
                    LOG.info((Object)("Added filter 'SPNEGO' (class=" + classname + ")"));
                    this.addJerseyResourcePackage(NamenodeWebHdfsMethods.class.getPackage().getName() + ";" + Param.class.getPackage().getName(), "/webhdfs/v1/*");
                }
            }

            private Map<String, String> getAuthFilterParams(Configuration conf) throws IOException {
                HashMap<String, String> params = new HashMap<String, String>();
                String principalInConf = conf.get("dfs.web.authentication.kerberos.principal");
                if (principalInConf != null && !principalInConf.isEmpty()) {
                    params.put("dfs.web.authentication.kerberos.principal", SecurityUtil.getServerPrincipal((String)principalInConf, (String)NameNodeHttpServer.this.bindAddress.getHostName()));
                } else if (UserGroupInformation.isSecurityEnabled()) {
                    LOG.error((Object)"WebHDFS and security are enabled, but configuration property 'dfs.web.authentication.kerberos.principal' is not set.");
                }
                String httpKeytab = conf.get(DFSUtil.getSpnegoKeytabKey(conf, "dfs.namenode.keytab.file"));
                if (httpKeytab != null && !httpKeytab.isEmpty()) {
                    params.put("dfs.web.authentication.kerberos.keytab", httpKeytab);
                } else if (UserGroupInformation.isSecurityEnabled()) {
                    LOG.error((Object)"WebHDFS and security are enabled, but configuration property 'dfs.web.authentication.kerberos.keytab' is not set.");
                }
                return params;
            }
        };
        boolean certSSL = this.conf.getBoolean("dfs.https.enable", false);
        if (certSSL) {
            boolean needClientAuth = this.conf.getBoolean("dfs.https.need.client.auth", false);
            InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr((String)(infoHost + ":" + this.conf.get("dfs.https.port", "0")));
            Configuration sslConf = new Configuration(false);
            if (certSSL) {
                sslConf.addResource(this.conf.get("dfs.https.server.keystore.resource", "ssl-server.xml"));
            }
            this.httpServer.addSslListener(secInfoSocAddr, sslConf, needClientAuth);
            InetSocketAddress datanodeSslPort = NetUtils.createSocketAddr((String)this.conf.get("dfs.datanode.https.address", infoHost + ":" + 50475));
            this.httpServer.setAttribute("datanode.https.port", (Object)datanodeSslPort.getPort());
        }
        this.httpServer.setAttribute(NAMENODE_ATTRIBUTE_KEY, (Object)this.nn);
        this.httpServer.setAttribute("current.conf", (Object)this.conf);
        NameNodeHttpServer.setupServlets(this.httpServer, this.conf);
        this.httpServer.start();
        this.httpAddress = new InetSocketAddress(this.bindAddress.getAddress(), this.httpServer.getPort());
    }

    public void stop() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public void setFSImage(FSImage fsImage) {
        this.httpServer.setAttribute(FSIMAGE_ATTRIBUTE_KEY, (Object)fsImage);
    }

    public void setNameNodeAddress(InetSocketAddress nameNodeAddress) {
        this.httpServer.setAttribute(NAMENODE_ADDRESS_ATTRIBUTE_KEY, (Object)NetUtils.getConnectAddress((InetSocketAddress)nameNodeAddress));
    }

    public void setStartupProgress(StartupProgress prog) {
        this.httpServer.setAttribute(STARTUP_PROGRESS_ATTRIBUTE_KEY, (Object)prog);
    }

    private static void setupServlets(HttpServer httpServer, Configuration conf) {
        httpServer.addInternalServlet("startupProgress", "/startupProgress", StartupProgressServlet.class);
        httpServer.addInternalServlet("getDelegationToken", "/getDelegationToken", GetDelegationTokenServlet.class, true);
        httpServer.addInternalServlet("renewDelegationToken", "/renewDelegationToken", RenewDelegationTokenServlet.class, true);
        httpServer.addInternalServlet("cancelDelegationToken", "/cancelDelegationToken", CancelDelegationTokenServlet.class, true);
        httpServer.addInternalServlet("fsck", "/fsck", FsckServlet.class, true);
        httpServer.addInternalServlet("getimage", "/getimage", GetImageServlet.class, true);
        httpServer.addInternalServlet("listPaths", "/listPaths/*", ListPathsServlet.class, false);
        httpServer.addInternalServlet("data", "/data/*", FileDataServlet.class, false);
        httpServer.addInternalServlet("checksum", "/fileChecksum/*", FileChecksumServlets.RedirectServlet.class, false);
        httpServer.addInternalServlet("contentSummary", "/contentSummary/*", ContentSummaryServlet.class, false);
    }

    public static FSImage getFsImageFromContext(ServletContext context) {
        return (FSImage)context.getAttribute(FSIMAGE_ATTRIBUTE_KEY);
    }

    public static NameNode getNameNodeFromContext(ServletContext context) {
        return (NameNode)context.getAttribute(NAMENODE_ATTRIBUTE_KEY);
    }

    public static Configuration getConfFromContext(ServletContext context) {
        return (Configuration)context.getAttribute("current.conf");
    }

    public static InetSocketAddress getNameNodeAddressFromContext(ServletContext context) {
        return (InetSocketAddress)context.getAttribute(NAMENODE_ADDRESS_ATTRIBUTE_KEY);
    }

    public static StartupProgress getStartupProgressFromContext(ServletContext context) {
        return (StartupProgress)context.getAttribute(STARTUP_PROGRESS_ATTRIBUTE_KEY);
    }
}

