/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileUnderConstructionWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

public class INodeDirectory
extends INodeWithAdditionalFields
implements INodeDirectoryAttributes {
    protected static final int DEFAULT_FILES_PER_DIRECTORY = 5;
    static final byte[] ROOT_NAME = DFSUtil.string2Bytes("");
    private List<INode> children = null;
    static final String DUMPTREE_EXCEPT_LAST_ITEM = "+-";
    static final String DUMPTREE_LAST_ITEM = "\\-";

    public static INodeDirectory valueOf(INode inode, Object path) throws FileNotFoundException, PathIsNotDirectoryException {
        if (inode == null) {
            throw new FileNotFoundException("Directory does not exist: " + DFSUtil.path2String(path));
        }
        if (!inode.isDirectory()) {
            throw new PathIsNotDirectoryException(DFSUtil.path2String(path));
        }
        return inode.asDirectory();
    }

    public INodeDirectory(long id, byte[] name, PermissionStatus permissions, long mtime) {
        super(id, name, permissions, mtime, 0L);
    }

    public INodeDirectory(INodeDirectory other, boolean adopt) {
        super(other);
        this.children = other.children;
        if (adopt && this.children != null) {
            for (INode child : this.children) {
                child.setParent(this);
            }
        }
    }

    @Override
    public final boolean isDirectory() {
        return true;
    }

    @Override
    public final INodeDirectory asDirectory() {
        return this;
    }

    public boolean isSnapshottable() {
        return false;
    }

    private int searchChildren(byte[] name) {
        return this.children == null ? -1 : Collections.binarySearch(this.children, name);
    }

    public boolean removeChild(INode child, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        if (this.isInLatestSnapshot(latest)) {
            return this.replaceSelf4INodeDirectoryWithSnapshot(inodeMap).removeChild(child, latest, inodeMap);
        }
        return this.removeChild(child);
    }

    protected final boolean removeChild(INode child) {
        int i = this.searchChildren(child.getLocalNameBytes());
        if (i < 0) {
            return false;
        }
        INode removed = this.children.remove(i);
        Preconditions.checkState((removed == child ? 1 : 0) != 0);
        return true;
    }

    INodeDirectoryWithQuota replaceSelf4Quota(Snapshot latest, long nsQuota, long dsQuota, INodeMap inodeMap) throws QuotaExceededException {
        Preconditions.checkState((!(this instanceof INodeDirectoryWithQuota) ? 1 : 0) != 0, (String)"this is already an INodeDirectoryWithQuota, this=%s", (Object[])new Object[]{this});
        if (!this.isInLatestSnapshot(latest)) {
            INodeDirectoryWithQuota q = new INodeDirectoryWithQuota(this, true, nsQuota, dsQuota);
            this.replaceSelf(q, inodeMap);
            return q;
        }
        INodeDirectoryWithSnapshot s = new INodeDirectoryWithSnapshot(this);
        s.setQuota(nsQuota, dsQuota);
        return this.replaceSelf(s, inodeMap).saveSelf2Snapshot(latest, this);
    }

    public INodeDirectorySnapshottable replaceSelf4INodeDirectorySnapshottable(Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        Preconditions.checkState((!(this instanceof INodeDirectorySnapshottable) ? 1 : 0) != 0, (String)"this is already an INodeDirectorySnapshottable, this=%s", (Object[])new Object[]{this});
        INodeDirectorySnapshottable s = new INodeDirectorySnapshottable(this);
        this.replaceSelf(s, inodeMap).saveSelf2Snapshot(latest, this);
        return s;
    }

    public INodeDirectoryWithSnapshot replaceSelf4INodeDirectoryWithSnapshot(INodeMap inodeMap) {
        return this.replaceSelf(new INodeDirectoryWithSnapshot(this), inodeMap);
    }

    public INodeDirectory replaceSelf4INodeDirectory(INodeMap inodeMap) {
        Preconditions.checkState((this.getClass() != INodeDirectory.class ? 1 : 0) != 0, (String)"the class is already INodeDirectory, this=%s", (Object[])new Object[]{this});
        return this.replaceSelf(new INodeDirectory(this, true), inodeMap);
    }

    private final <N extends INodeDirectory> N replaceSelf(N newDir, INodeMap inodeMap) {
        INodeReference ref = this.getParentReference();
        if (ref != null) {
            ref.setReferredINode(newDir);
            if (inodeMap != null) {
                inodeMap.put(newDir);
            }
        } else {
            INodeDirectory parent = this.getParent();
            Preconditions.checkArgument((parent != null ? 1 : 0) != 0, (String)"parent is null, this=%s", (Object[])new Object[]{this});
            parent.replaceChild(this, newDir, inodeMap);
        }
        this.clear();
        return newDir;
    }

    public void replaceChild(INode oldChild, INode newChild, INodeMap inodeMap) {
        Preconditions.checkNotNull(this.children);
        int i = this.searchChildren(newChild.getLocalNameBytes());
        Preconditions.checkState((i >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((oldChild == this.children.get(i) || oldChild == this.children.get(i).asReference().getReferredINode().asReference().getReferredINode() ? 1 : 0) != 0);
        oldChild = this.children.get(i);
        if (oldChild.isReference() && !newChild.isReference()) {
            INode withCount = oldChild.asReference().getReferredINode();
            withCount.asReference().setReferredINode(newChild);
        } else {
            if (oldChild.isReference()) {
                INodeReference.WithCount withCount = (INodeReference.WithCount)oldChild.asReference().getReferredINode();
                withCount.removeReference(oldChild.asReference());
            }
            this.children.set(i, newChild);
        }
        if (inodeMap != null) {
            inodeMap.put(newChild);
        }
    }

    INodeReference.WithName replaceChild4ReferenceWithName(INode oldChild, Snapshot latest) {
        INodeReference.WithCount withCount;
        Preconditions.checkArgument((latest != null ? 1 : 0) != 0);
        if (oldChild instanceof INodeReference.WithName) {
            return (INodeReference.WithName)oldChild;
        }
        if (oldChild.isReference()) {
            Preconditions.checkState((boolean)(oldChild instanceof INodeReference.DstReference));
            withCount = (INodeReference.WithCount)oldChild.asReference().getReferredINode();
        } else {
            withCount = new INodeReference.WithCount(null, oldChild);
        }
        INodeReference.WithName ref = new INodeReference.WithName(this, withCount, oldChild.getLocalNameBytes(), latest.getId());
        this.replaceChild(oldChild, ref, null);
        return ref;
    }

    private void replaceChildFile(INodeFile oldChild, INodeFile newChild, INodeMap inodeMap) {
        this.replaceChild(oldChild, newChild, inodeMap);
        oldChild.clear();
        newChild.updateBlockCollection();
    }

    INodeFileWithSnapshot replaceChild4INodeFileWithSnapshot(INodeFile child, INodeMap inodeMap) {
        Preconditions.checkArgument((!(child instanceof INodeFileWithSnapshot) ? 1 : 0) != 0, (Object)("Child file is already an INodeFileWithSnapshot, child=" + child));
        INodeFileWithSnapshot newChild = new INodeFileWithSnapshot(child);
        this.replaceChildFile(child, newChild, inodeMap);
        return newChild;
    }

    INodeFileUnderConstructionWithSnapshot replaceChild4INodeFileUcWithSnapshot(INodeFileUnderConstruction child, INodeMap inodeMap) {
        Preconditions.checkArgument((!(child instanceof INodeFileUnderConstructionWithSnapshot) ? 1 : 0) != 0, (Object)("Child file is already an INodeFileUnderConstructionWithSnapshot, child=" + child));
        INodeFileUnderConstructionWithSnapshot newChild = new INodeFileUnderConstructionWithSnapshot(child, null);
        this.replaceChildFile(child, newChild, inodeMap);
        return newChild;
    }

    @Override
    public INodeDirectory recordModification(Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        if (this.isInLatestSnapshot(latest)) {
            return this.replaceSelf4INodeDirectoryWithSnapshot(inodeMap).recordModification(latest, inodeMap);
        }
        return this;
    }

    public INode saveChild2Snapshot(INode child, Snapshot latest, INode snapshotCopy, INodeMap inodeMap) throws QuotaExceededException {
        if (latest == null) {
            return child;
        }
        return this.replaceSelf4INodeDirectoryWithSnapshot(inodeMap).saveChild2Snapshot(child, latest, snapshotCopy, inodeMap);
    }

    public INode getChild(byte[] name, Snapshot snapshot) {
        ReadOnlyList<INode> c = this.getChildrenList(snapshot);
        int i = ReadOnlyList.Util.binarySearch(c, name);
        return i < 0 ? null : c.get(i);
    }

    INodesInPath getLastINodeInPath(String path, boolean resolveLink) throws UnresolvedLinkException {
        return INodesInPath.resolve(this, INodeDirectory.getPathComponents(path), 1, resolveLink);
    }

    INodesInPath getINodesInPath(String path, boolean resolveLink) throws UnresolvedLinkException {
        byte[][] components = INodeDirectory.getPathComponents(path);
        return INodesInPath.resolve(this, components, components.length, resolveLink);
    }

    INode getNode(String path, boolean resolveLink) throws UnresolvedLinkException {
        return this.getLastINodeInPath(path, resolveLink).getINode(0);
    }

    INode getINode4Write(String src, boolean resolveLink) throws UnresolvedLinkException, SnapshotAccessControlException {
        return this.getINodesInPath4Write(src, resolveLink).getLastINode();
    }

    INodesInPath getINodesInPath4Write(String src, boolean resolveLink) throws UnresolvedLinkException, SnapshotAccessControlException {
        byte[][] components = INode.getPathComponents(src);
        INodesInPath inodesInPath = INodesInPath.resolve(this, components, components.length, resolveLink);
        if (inodesInPath.isSnapshot()) {
            throw new SnapshotAccessControlException("Modification on a read-only snapshot is disallowed");
        }
        return inodesInPath;
    }

    static int nextChild(ReadOnlyList<INode> children, byte[] name) {
        if (name.length == 0) {
            return 0;
        }
        int nextPos = ReadOnlyList.Util.binarySearch(children, name) + 1;
        if (nextPos >= 0) {
            return nextPos;
        }
        return -nextPos;
    }

    public boolean addChild(INode node, boolean setModTime, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        int low = this.searchChildren(node.getLocalNameBytes());
        if (low >= 0) {
            return false;
        }
        if (this.isInLatestSnapshot(latest)) {
            INodeDirectoryWithSnapshot sdir = this.replaceSelf4INodeDirectoryWithSnapshot(inodeMap);
            boolean added = sdir.addChild(node, setModTime, latest, inodeMap);
            return added;
        }
        this.addChild(node, low);
        if (setModTime) {
            this.updateModificationTime(node.getModificationTime(), latest, inodeMap);
        }
        return true;
    }

    public boolean addChild(INode node) {
        int low = this.searchChildren(node.getLocalNameBytes());
        if (low >= 0) {
            return false;
        }
        this.addChild(node, low);
        return true;
    }

    private void addChild(INode node, int insertionPoint) {
        if (this.children == null) {
            this.children = new ArrayList<INode>(5);
        }
        node.setParent(this);
        this.children.add(-insertionPoint - 1, node);
        if (node.getGroupName() == null) {
            node.setGroup(this.getGroupName());
        }
    }

    @Override
    public Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
        if (this.children != null) {
            for (INode child : this.children) {
                child.computeQuotaUsage(counts, useCache, lastSnapshotId);
            }
        }
        return this.computeQuotaUsage4CurrentDirectory(counts);
    }

    public Quota.Counts computeQuotaUsage4CurrentDirectory(Quota.Counts counts) {
        counts.add(Quota.NAMESPACE, 1L);
        return counts;
    }

    @Override
    public Content.Counts computeContentSummary(Content.Counts counts) {
        for (INode child : this.getChildrenList(null)) {
            child.computeContentSummary(counts);
        }
        counts.add(Content.DIRECTORY, 1L);
        return counts;
    }

    public ReadOnlyList<INode> getChildrenList(Snapshot snapshot) {
        return this.children == null ? ReadOnlyList.Util.emptyList() : ReadOnlyList.Util.asReadOnlyList(this.children);
    }

    public void clearChildren() {
        this.children = null;
    }

    @Override
    public void clear() {
        super.clear();
        this.clearChildren();
    }

    public Quota.Counts cleanSubtreeRecursively(Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, Map<INode, INode> excludedNodes, boolean countDiffChange) throws QuotaExceededException {
        Quota.Counts counts = Quota.Counts.newInstance();
        Snapshot s = snapshot != null && prior != null ? prior : snapshot;
        for (INode child : this.getChildrenList(s)) {
            if (snapshot != null && excludedNodes != null && excludedNodes.containsKey(child)) continue;
            Quota.Counts childCounts = child.cleanSubtree(snapshot, prior, collectedBlocks, removedINodes, countDiffChange);
            counts.add(childCounts);
        }
        return counts;
    }

    @Override
    public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        for (INode child : this.getChildrenList(null)) {
            child.destroyAndCollectBlocks(collectedBlocks, removedINodes);
        }
        this.clear();
        removedINodes.add(this);
    }

    @Override
    public Quota.Counts cleanSubtree(Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) throws QuotaExceededException {
        if (prior == null && snapshot == null) {
            Quota.Counts counts = Quota.Counts.newInstance();
            this.computeQuotaUsage(counts, true);
            this.destroyAndCollectBlocks(collectedBlocks, removedINodes);
            return counts;
        }
        Quota.Counts counts = this.cleanSubtreeRecursively(snapshot, prior, collectedBlocks, removedINodes, null, countDiffChange);
        if (this.isQuotaSet()) {
            ((INodeDirectoryWithQuota)this).addSpaceConsumed2Cache(-counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
        }
        return counts;
    }

    @Override
    public boolean metadataEquals(INodeDirectoryAttributes other) {
        return other != null && this.getNsQuota() == other.getNsQuota() && this.getDsQuota() == other.getDsQuota() && this.getPermissionLong() == other.getPermissionLong();
    }

    @Override
    @VisibleForTesting
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, final Snapshot snapshot) {
        super.dumpTreeRecursively(out, prefix, snapshot);
        out.print(", childrenSize=" + this.getChildrenList(snapshot).size());
        if (this instanceof INodeDirectoryWithQuota) {
            out.print(((INodeDirectoryWithQuota)this).quotaString());
        }
        if (this instanceof Snapshot.Root) {
            out.print(", snapshotId=" + snapshot.getId());
        }
        out.println();
        if (prefix.length() >= 2) {
            prefix.setLength(prefix.length() - 2);
            prefix.append("  ");
        }
        INodeDirectory.dumpTreeRecursively(out, prefix, new Iterable<SnapshotAndINode>(){
            final Iterator<INode> i;
            {
                this.i = INodeDirectory.this.getChildrenList(snapshot).iterator();
            }

            @Override
            public Iterator<SnapshotAndINode> iterator() {
                return new Iterator<SnapshotAndINode>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public SnapshotAndINode next() {
                        return new SnapshotAndINode(snapshot, i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    @VisibleForTesting
    protected static void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, Iterable<SnapshotAndINode> subs) {
        if (subs != null) {
            Iterator<SnapshotAndINode> i = subs.iterator();
            while (i.hasNext()) {
                SnapshotAndINode pair = i.next();
                prefix.append(i.hasNext() ? DUMPTREE_EXCEPT_LAST_ITEM : DUMPTREE_LAST_ITEM);
                pair.inode.dumpTreeRecursively(out, prefix, pair.snapshot);
                prefix.setLength(prefix.length() - 2);
            }
        }
    }

    public final int getChildrenNum(Snapshot snapshot) {
        return this.getChildrenList(snapshot).size();
    }

    protected static class SnapshotAndINode {
        public final Snapshot snapshot;
        public final INode inode;

        public SnapshotAndINode(Snapshot snapshot, INode inode) {
            this.snapshot = snapshot;
            this.inode = inode;
        }

        public SnapshotAndINode(Snapshot snapshot) {
            this(snapshot, snapshot.getRoot());
        }
    }
}

