/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.Message;
import org.jgroups.Version;
import org.jgroups.protocols.TP;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public class ParseMessages {
    InputStream input = null;
    private static final byte LIST = 1;
    private static final byte MULTICAST = 2;

    public ParseMessages(String input) throws FileNotFoundException {
        this.input = new FileInputStream(input);
    }

    public ParseMessages(InputStream input) {
        this.input = input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> parse() {
        ArrayList<Message> arrayList;
        ArrayList<Message> retval = new ArrayList<Message>();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(this.input);
            block6: while (true) {
                boolean multicast;
                short version;
                try {
                    version = dis.readShort();
                }
                catch (IOException io_ex) {
                    break;
                }
                System.out.println("version = " + version + " (" + Version.print(version) + ")");
                byte flags = dis.readByte();
                System.out.println("flags: " + Message.flagsToString(flags));
                boolean is_message_list = (flags & 1) == 1;
                boolean bl = multicast = (flags & 2) == 2;
                if (is_message_list) {
                    MessageBatch[] batches;
                    MessageBatch[] arr$ = batches = TP.readMessageBatch(dis, multicast);
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block6;
                        MessageBatch batch = arr$[i$];
                        if (batch != null) {
                            for (Message msg : batch) {
                                retval.add(msg);
                            }
                        }
                        ++i$;
                    }
                }
                Message msg = TP.readMessage(dis);
                retval.add(msg);
            }
            arrayList = retval;
        }
        catch (Throwable t) {
            List<Message> list;
            try {
                t.printStackTrace();
                list = null;
            }
            catch (Throwable throwable) {
                Util.close(dis);
                throw throwable;
            }
            Util.close((Closeable)dis);
            return list;
        }
        Util.close((Closeable)dis);
        return arrayList;
    }

    private static void print(Message msg, boolean multicast) {
        System.out.println(msg + ", hdrs: " + msg.printHeaders() + ", mcast: " + multicast);
    }

    public static void main(String[] args) throws FileNotFoundException {
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-file")) {
                ParseMessages.help();
                return;
            }
            file = args[++i];
        }
        List<Message> msgs = new ParseMessages(file).parse();
        int cnt = 1;
        for (Message msg : msgs) {
            System.out.println(cnt++ + ": " + msg + ", hdrs: " + msg.printHeaders());
        }
    }

    private static void help() {
        System.out.println("ParseMessages [-file <filename>]");
    }
}

