/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket.config;

import com.couchbase.client.vbucket.config.CacheConfig;
import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigFactory;
import com.couchbase.client.vbucket.config.ConfigParsingException;
import com.couchbase.client.vbucket.config.DefaultConfig;
import com.couchbase.client.vbucket.config.VBucket;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.HashAlgorithmRegistry;
import net.spy.memcached.compat.SpyObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DefaultConfigFactory
extends SpyObject
implements ConfigFactory {
    @Override
    public Config create(File filename) {
        if (filename == null || "".equals(filename.getName())) {
            throw new IllegalArgumentException("Filename is empty.");
        }
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            while ((str = reader.readLine()) != null) {
                sb.append(str);
            }
        }
        catch (IOException e) {
            throw new ConfigParsingException("Exception reading input file: " + filename, e);
        }
        return this.create(sb.toString());
    }

    @Override
    public Config create(String data) {
        try {
            JSONObject jsonObject = new JSONObject(data);
            return this.parseJSON(jsonObject);
        }
        catch (JSONException e) {
            throw new ConfigParsingException("Exception parsing JSON data: " + data, e);
        }
    }

    @Override
    public Config create(JSONObject jsonObject) {
        try {
            return this.parseJSON(jsonObject);
        }
        catch (JSONException e) {
            throw new ConfigParsingException("Exception parsing JSON data: " + jsonObject, e);
        }
    }

    private Config parseJSON(JSONObject jsonObject) throws JSONException {
        if (!jsonObject.has("vBucketServerMap")) {
            return this.parseCacheJSON(jsonObject);
        }
        return this.parseEpJSON(jsonObject);
    }

    private Config parseCacheJSON(JSONObject jsonObject) throws JSONException {
        JSONArray nodes = jsonObject.getJSONArray("nodes");
        if (nodes.length() <= 0) {
            throw new ConfigParsingException("Empty nodes list.");
        }
        int serversCount = nodes.length();
        CacheConfig config = new CacheConfig(serversCount);
        this.populateServers(config, nodes);
        return config;
    }

    private Config parseEpJSON(JSONObject jsonObject) throws JSONException {
        JSONObject vbMap = jsonObject.getJSONObject("vBucketServerMap");
        String algorithm = vbMap.getString("hashAlgorithm");
        HashAlgorithm hashAlgorithm = HashAlgorithmRegistry.lookupHashAlgorithm((String)algorithm);
        if (hashAlgorithm == null) {
            throw new IllegalArgumentException("Unhandled hash algorithm type: " + algorithm);
        }
        int replicasCount = vbMap.getInt("numReplicas");
        if (replicasCount > 4) {
            throw new ConfigParsingException("Expected number <= 4 for replicas.");
        }
        JSONArray servers = vbMap.getJSONArray("serverList");
        if (servers.length() <= 0) {
            throw new ConfigParsingException("Empty servers list.");
        }
        int serversCount = servers.length();
        JSONArray vbuckets = vbMap.getJSONArray("vBucketMap");
        int vbucketsCount = vbuckets.length();
        if (vbucketsCount == 0 || (vbucketsCount & vbucketsCount - 1) != 0) {
            throw new ConfigParsingException("Number of vBuckets must be a power of two, > 0 and <= 65536");
        }
        List<String> populateServers = this.populateServers(servers);
        List<VBucket> populateVbuckets = this.populateVbuckets(vbuckets);
        List<URL> couchServers = this.populateCouchServers(jsonObject.getJSONArray("nodes"));
        DefaultConfig config = new DefaultConfig(hashAlgorithm, serversCount, replicasCount, vbucketsCount, populateServers, populateVbuckets, couchServers);
        return config;
    }

    private List<URL> populateCouchServers(JSONArray nodes) throws JSONException {
        ArrayList<URL> nodeNames = new ArrayList<URL>();
        for (int i = 0; i < nodes.length(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            if (!node.has("couchApiBase")) continue;
            try {
                nodeNames.add(new URL(node.getString("couchApiBase")));
                continue;
            }
            catch (MalformedURLException e) {
                throw new JSONException("Got bad couchApiBase URL from config");
            }
        }
        return nodeNames;
    }

    private List<String> populateServers(JSONArray servers) throws JSONException {
        ArrayList<String> serverNames = new ArrayList<String>();
        for (int i = 0; i < servers.length(); ++i) {
            String server = servers.getString(i);
            serverNames.add(server);
        }
        return serverNames;
    }

    private void populateServers(CacheConfig config, JSONArray nodes) throws JSONException {
        ArrayList<String> serverNames = new ArrayList<String>();
        for (int i = 0; i < nodes.length(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            String webHostPort = node.getString("hostname");
            String[] splitHostPort = webHostPort.split(":");
            JSONObject portsList = node.getJSONObject("ports");
            int port = portsList.getInt("direct");
            serverNames.add(splitHostPort[0] + ":" + port);
        }
        config.setServers(serverNames);
    }

    private List<VBucket> populateVbuckets(JSONArray jsonVbuckets) throws JSONException {
        ArrayList<VBucket> vBuckets = new ArrayList<VBucket>();
        for (int i = 0; i < jsonVbuckets.length(); ++i) {
            JSONArray rows = jsonVbuckets.getJSONArray(i);
            int master = rows.getInt(0);
            int[] replicas = new int[4];
            for (int j = 1; j < rows.length(); ++j) {
                replicas[j - 1] = rows.getInt(j);
            }
            vBuckets.add(new VBucket(master, replicas));
        }
        return vBuckets;
    }
}

