/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.protocol.views;

import com.couchbase.client.protocol.views.AbstractView;
import com.couchbase.client.protocol.views.HttpOperationImpl;
import com.couchbase.client.protocol.views.ViewOperation;
import com.couchbase.client.protocol.views.ViewResponse;
import java.text.ParseException;
import java.util.logging.Logger;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationException;
import net.spy.memcached.ops.OperationStatus;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public abstract class ViewOperationImpl
extends HttpOperationImpl
implements ViewOperation {
    private AbstractView view;
    protected static final Logger LOGGER = Logger.getLogger(ViewOperationImpl.class.getName());

    public ViewOperationImpl(HttpRequest r, AbstractView view, OperationCallback cb) {
        super(r, cb);
        this.view = view;
    }

    public AbstractView getView() {
        return this.view;
    }

    @Override
    public void handleResponse(HttpResponse response) {
        String json = this.getEntityString(response);
        int errorcode = response.getStatusLine().getStatusCode();
        try {
            OperationStatus status = this.parseViewForStatus(json, errorcode);
            ViewResponse vr = null;
            if (status.isSuccess()) {
                vr = this.parseResult(json);
            } else {
                this.parseError(json, errorcode);
            }
            ((ViewOperation.ViewCallback)this.callback).gotData(vr);
            this.callback.receivedStatus(status);
        }
        catch (ParseException e) {
            this.setException(new OperationException(OperationErrorType.GENERAL, "Error parsing JSON"));
        }
        this.callback.complete();
    }

    protected abstract void parseError(String var1, int var2) throws ParseException;

    protected abstract ViewResponse parseResult(String var1) throws ParseException;
}

