/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.protocol.views;

import com.couchbase.client.protocol.views.HttpOperationImpl;
import com.couchbase.client.protocol.views.SpatialView;
import com.couchbase.client.protocol.views.SpatialViewFetcherOperation;
import java.text.ParseException;
import java.util.Iterator;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationException;
import net.spy.memcached.ops.OperationStatus;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SpatialViewFetcherOperationImpl
extends HttpOperationImpl
implements SpatialViewFetcherOperation {
    private final String bucketName;
    private final String designDocName;
    private final String viewName;

    public SpatialViewFetcherOperationImpl(HttpRequest r, String bucketName, String designDocName, String viewName, SpatialViewFetcherOperation.ViewFetcherCallback viewCallback) {
        super(r, viewCallback);
        this.bucketName = bucketName;
        this.designDocName = designDocName;
        this.viewName = viewName;
    }

    @Override
    public void handleResponse(HttpResponse response) {
        String json = this.getEntityString(response);
        try {
            SpatialView view = this.parseDesignDocumentForView(this.bucketName, this.designDocName, this.viewName, json);
            int errorcode = response.getStatusLine().getStatusCode();
            if (errorcode == 200) {
                ((SpatialViewFetcherOperation.ViewFetcherCallback)this.callback).gotData(view);
                this.callback.receivedStatus(new OperationStatus(true, "OK"));
            } else {
                this.callback.receivedStatus(new OperationStatus(false, Integer.toString(errorcode)));
            }
        }
        catch (ParseException e) {
            this.exception = new OperationException(OperationErrorType.GENERAL, "Error parsing JSON");
        }
        this.callback.complete();
    }

    private SpatialView parseDesignDocumentForView(String dn, String ddn, String viewname, String json) throws ParseException {
        SpatialView view;
        block5: {
            view = null;
            if (json != null) {
                try {
                    JSONObject base = new JSONObject(json);
                    if (base.has("error")) {
                        return null;
                    }
                    if (!base.has("spatial")) break block5;
                    JSONObject views = base.getJSONObject("spatial");
                    Iterator itr = views.keys();
                    while (itr.hasNext()) {
                        String curView = (String)itr.next();
                        if (!curView.equals(viewname)) continue;
                        view = new SpatialView(dn, ddn, viewname);
                        break;
                    }
                }
                catch (JSONException e) {
                    throw new ParseException("Cannot read json: " + json, 0);
                }
            }
        }
        return view;
    }
}

