/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.internal;

import com.couchbase.client.CouchbaseConnection;
import com.couchbase.client.CouchbaseProperties;
import com.couchbase.client.internal.Throttler;
import com.couchbase.client.internal.ThrottlerState;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatsOperation;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;

public class AdaptiveThrottler
extends SpyObject
implements Throttler {
    private final int normalStatsInterval;
    private final int highStatsInterval;
    private final int criticalStatsInterval;
    private final int highSleep;
    private final int criticalSleep;
    private int intervalCounter = 0;
    private CouchbaseConnection conn;
    private InetSocketAddress node;
    private ThrottlerState currentState = ThrottlerState.NORMAL;
    private BinaryOperationFactory opFact;

    public AdaptiveThrottler(CouchbaseConnection conn, BinaryOperationFactory opFact, InetSocketAddress node) {
        this(conn, opFact, node, Integer.parseInt(CouchbaseProperties.getProperty("normal_stats_interval", "10000")), Integer.parseInt(CouchbaseProperties.getProperty("high_stats_interval", "100")), Integer.parseInt(CouchbaseProperties.getProperty("critical_stats_interval", "10")), Integer.parseInt(CouchbaseProperties.getProperty("high_sleep_time", "1")), Integer.parseInt(CouchbaseProperties.getProperty("critical_sleep_time", "3")));
    }

    public AdaptiveThrottler(CouchbaseConnection conn, BinaryOperationFactory opFact, InetSocketAddress node, int normalStatsInterval, int highStatsInterval, int criticalStatsInterval, int highSleep, int criticalSleep) {
        this.conn = conn;
        this.opFact = opFact;
        this.node = node;
        this.normalStatsInterval = normalStatsInterval;
        this.highStatsInterval = highStatsInterval;
        this.criticalStatsInterval = criticalStatsInterval;
        this.highSleep = highSleep;
        this.criticalSleep = criticalSleep;
        this.logCreation();
    }

    @Override
    public void throttle() {
        ++this.intervalCounter;
        if (this.statsNeedFetch()) {
            Map<String, String> stats = this.gatherStats();
            int throttleTime = this.throttleNeeded(stats);
            if (throttleTime > 0) {
                this.getLogger().debug((Object)("Throttling operation for " + throttleTime + "ms"));
                try {
                    Thread.sleep(throttleTime);
                }
                catch (InterruptedException ex) {
                    this.getLogger().warn((Object)"Interrupted while Throttling!");
                    return;
                }
            }
            this.intervalCounter = 0;
        }
    }

    private int throttleNeeded(Map<String, String> stats) {
        long memUsed;
        long highWater;
        try {
            highWater = Long.parseLong(stats.get("ep_mem_high_wat"));
            memUsed = Long.parseLong(stats.get("mem_used"));
        }
        catch (NumberFormatException ex) {
            this.getLogger().warn((Object)"Received throttle stats invalid, skipping interval.");
            return 0;
        }
        if (memUsed >= highWater + highWater / 10L) {
            this.currentState = ThrottlerState.CRITICAL;
            return this.criticalSleep;
        }
        if (memUsed >= highWater) {
            this.currentState = ThrottlerState.HIGH;
            return this.highSleep;
        }
        this.currentState = ThrottlerState.NORMAL;
        return 0;
    }

    private Map<String, String> gatherStats() {
        final HashMap rv = new HashMap();
        CountDownLatch blatch = this.conn.broadcastOperation(new BroadcastOpFactory(){

            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                final InetSocketAddress sa = (InetSocketAddress)n.getSocketAddress();
                rv.put(sa, new HashMap());
                return AdaptiveThrottler.this.opFact.stats(null, new StatsOperation.Callback(){

                    public void gotStat(String name, String val) {
                        ((Map)rv.get(sa)).put(name, val);
                    }

                    public void receivedStatus(OperationStatus status) {
                        if (!status.isSuccess()) {
                            AdaptiveThrottler.this.getLogger().warn((Object)("Unsuccessful stats fetch: " + status));
                        }
                    }

                    public void complete() {
                        latch.countDown();
                    }
                });
            }
        });
        try {
            blatch.await(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for stats", e);
        }
        return (Map)rv.get(this.node);
    }

    private boolean statsNeedFetch() {
        if (this.currentState == ThrottlerState.NORMAL && this.intervalCounter >= this.normalStatsInterval) {
            return true;
        }
        if (this.currentState == ThrottlerState.HIGH && this.intervalCounter >= this.highStatsInterval) {
            return true;
        }
        return this.currentState == ThrottlerState.CRITICAL && this.intervalCounter >= this.criticalStatsInterval;
    }

    private void logCreation() {
        this.getLogger().info((Object)("AdaptiveThrottler instantiated with options normal_stats_interval: " + this.normalStatsInterval + " high_stats_interval: " + this.highStatsInterval + " critical_stats_interval: " + this.criticalStatsInterval + " high_sleep: " + this.highSleep + " critical_sleep: " + this.criticalSleep + " - for node " + this.node));
    }
}

